/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.TenantResolver;
import io.quarkus.oidc.common.runtime.OidcCommonUtils;
import io.quarkus.oidc.runtime.OidcUtils;
import io.quarkus.oidc.runtime.TenantConfigBean;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.quarkus.vertx.http.runtime.security.ImmutablePathMatcher;
import io.smallrye.mutiny.Uni;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.inject.Instance;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import org.eclipse.microprofile.jwt.Claims;
import org.jboss.logging.Logger;

final class StaticTenantResolver {
    private static final Logger LOG = Logger.getLogger(StaticTenantResolver.class);
    private final TenantResolver[] staticTenantResolvers;
    private final IssuerBasedTenantResolver issuerBasedTenantResolver;

    StaticTenantResolver(TenantConfigBean tenantConfigBean, String rootPath, boolean resolveTenantsWithIssuer, Instance<TenantResolver> tenantResolverInstance) {
        PathMatchingTenantResolver pathMatchingTenantResolver;
        ArrayList<TenantResolver> staticTenantResolvers = new ArrayList<TenantResolver>();
        if (tenantResolverInstance.isResolvable()) {
            if (tenantResolverInstance.isAmbiguous()) {
                throw new IllegalStateException("Multiple " + String.valueOf(TenantResolver.class) + " beans registered");
            }
            staticTenantResolvers.add((TenantResolver)tenantResolverInstance.get());
        }
        if ((pathMatchingTenantResolver = PathMatchingTenantResolver.of(tenantConfigBean.getStaticTenantsConfig(), rootPath, tenantConfigBean.getDefaultTenant())) != null) {
            staticTenantResolvers.add(pathMatchingTenantResolver);
        }
        if (!tenantConfigBean.getStaticTenantsConfig().isEmpty()) {
            staticTenantResolvers.add(new DefaultStaticTenantResolver(tenantConfigBean));
        }
        this.staticTenantResolvers = staticTenantResolvers.toArray(new TenantResolver[0]);
        this.issuerBasedTenantResolver = resolveTenantsWithIssuer ? IssuerBasedTenantResolver.of(tenantConfigBean.getStaticTenantsConfig(), tenantConfigBean.getDefaultTenant()) : null;
    }

    Uni<String> resolve(RoutingContext context) {
        for (TenantResolver resolver : this.staticTenantResolvers) {
            String tenantId = resolver.resolve(context);
            if (tenantId == null) continue;
            return Uni.createFrom().item((Object)tenantId);
        }
        if (this.issuerBasedTenantResolver != null) {
            return this.issuerBasedTenantResolver.resolveTenant(context);
        }
        return Uni.createFrom().nullItem();
    }

    private static final class PathMatchingTenantResolver
    implements TenantResolver {
        private static final String DEFAULT_TENANT = "PathMatchingTenantResolver#DefaultTenant";
        private final ImmutablePathMatcher<String> staticTenantPaths;

        private PathMatchingTenantResolver(ImmutablePathMatcher<String> staticTenantPaths) {
            this.staticTenantPaths = staticTenantPaths;
        }

        private static PathMatchingTenantResolver of(Map<String, TenantConfigContext> staticTenantsConfig, String rootPath, TenantConfigContext defaultTenant) {
            ImmutablePathMatcher.ImmutablePathMatcherBuilder builder = ImmutablePathMatcher.builder().rootPath(rootPath);
            PathMatchingTenantResolver.addPath(DEFAULT_TENANT, defaultTenant.oidcConfig(), (ImmutablePathMatcher.ImmutablePathMatcherBuilder<String>)builder);
            for (Map.Entry<String, TenantConfigContext> e : staticTenantsConfig.entrySet()) {
                PathMatchingTenantResolver.addPath(e.getKey(), e.getValue().oidcConfig(), (ImmutablePathMatcher.ImmutablePathMatcherBuilder<String>)builder);
            }
            return builder.hasPaths() ? new PathMatchingTenantResolver((ImmutablePathMatcher<String>)builder.build()) : null;
        }

        @Override
        public String resolve(RoutingContext context) {
            String tenantId = (String)this.staticTenantPaths.match(context.normalizedPath()).getValue();
            if (tenantId != null) {
                LOG.debugf("Tenant id '%s' is selected on the '%s' request path", (Object)tenantId, (Object)context.normalizedPath());
                return tenantId;
            }
            return null;
        }

        private static ImmutablePathMatcher.ImmutablePathMatcherBuilder<String> addPath(String tenant, OidcTenantConfig config, ImmutablePathMatcher.ImmutablePathMatcherBuilder<String> builder) {
            if (config != null && config.tenantPaths().isPresent()) {
                for (String path : config.tenantPaths().get()) {
                    builder.addPath(path, (Object)tenant);
                }
            }
            return builder;
        }
    }

    private static final class DefaultStaticTenantResolver
    implements TenantResolver {
        private static final String PATH_SEPARATOR = "/";
        private final TenantConfigBean tenantConfigBean;

        private DefaultStaticTenantResolver(TenantConfigBean tenantConfigBean) {
            this.tenantConfigBean = tenantConfigBean;
        }

        @Override
        public String resolve(RoutingContext context) {
            String[] pathSegments;
            for (String segment : pathSegments = context.request().path().split(PATH_SEPARATOR)) {
                if (this.tenantConfigBean.getStaticTenant(segment) == null) continue;
                LOG.debugf("Tenant id '%s' is selected on the '%s' request path", (Object)segment, (Object)context.normalizedPath());
                return segment;
            }
            return null;
        }
    }

    private static final class IssuerBasedTenantResolver {
        private final TenantConfigContext[] tenantConfigContexts;
        private final boolean detectedTenantWithoutMetadata;
        private final Map<String, AtomicBoolean> tenantToRetry;

        private IssuerBasedTenantResolver(TenantConfigContext[] tenantConfigContexts, boolean detectedTenantWithoutMetadata, Map<String, AtomicBoolean> tenantToRetry) {
            this.tenantConfigContexts = tenantConfigContexts;
            this.detectedTenantWithoutMetadata = detectedTenantWithoutMetadata;
            this.tenantToRetry = tenantToRetry;
        }

        private Uni<String> resolveTenant(RoutingContext context) {
            return this.resolveTenant(context, 0);
        }

        private Uni<String> resolveTenant(final RoutingContext context, final int index) {
            if (index == this.tenantConfigContexts.length) {
                return Uni.createFrom().nullItem();
            }
            TenantConfigContext tenantContext = this.tenantConfigContexts[index];
            if (this.detectedTenantWithoutMetadata) {
                if (tenantContext.getOidcMetadata() == null) {
                    if (tenantContext.ready()) {
                        if (IssuerBasedTenantResolver.isTenantWithIssuer(tenantContext)) {
                            return this.getTenantId(tenantContext, context, index);
                        }
                        return this.resolveTenant(context, index + 1);
                    }
                    if (!this.tryToInitialize(tenantContext)) {
                        return this.resolveTenant(context, index + 1);
                    }
                    return tenantContext.initialize().onItemOrFailure().transformToUni((BiFunction)new BiFunction<TenantConfigContext, Throwable, Uni<? extends String>>(){

                        @Override
                        public Uni<String> apply(TenantConfigContext newContext, Throwable throwable) {
                            if (throwable != null) {
                                return this.resolveTenant(context, index + 1);
                            }
                            if (newContext.ready() && IssuerBasedTenantResolver.isTenantWithIssuer(newContext)) {
                                return this.getTenantId(newContext, context, index);
                            }
                            return this.resolveTenant(context, index + 1);
                        }
                    });
                }
                if (IssuerBasedTenantResolver.isTenantWithoutIssuer(tenantContext)) {
                    return this.resolveTenant(context, index + 1);
                }
            }
            return this.getTenantId(tenantContext, context, index);
        }

        private Uni<String> getTenantId(TenantConfigContext tenantContext, RoutingContext context, int index) {
            String tenantId = IssuerBasedTenantResolver.getTenantId(context, tenantContext);
            if (tenantId == null) {
                return this.resolveTenant(context, index + 1);
            }
            return Uni.createFrom().item((Object)tenantId);
        }

        private boolean tryToInitialize(TenantConfigContext context) {
            String tenantId = context.oidcConfig().tenantId().get();
            return this.tenantToRetry.get(tenantId).compareAndExchange(true, false);
        }

        private static String getTenantId(RoutingContext context, TenantConfigContext tenantContext) {
            String iss;
            JsonObject tokenJson;
            String token = OidcUtils.extractBearerToken(context, tenantContext.oidcConfig());
            if (token != null && !OidcUtils.isOpaqueToken(token) && (tokenJson = OidcCommonUtils.decodeJwtContent((String)token)) != null && (iss = tokenJson.getString(Claims.iss.name())) != null && iss.equals(IssuerBasedTenantResolver.getIssuer(tenantContext))) {
                String tenantId = tenantContext.oidcConfig().tenantId().get();
                if (!IssuerBasedTenantResolver.requiredClaimsMatch(tenantContext.oidcConfig().token().requiredClaims(), tokenJson)) {
                    LOG.debugf("OIDC tenant '%s' issuer matches the token issuer '%s' but does not match the token required claims", (Object)tenantId, (Object)iss);
                    return null;
                }
                OidcUtils.storeExtractedBearerToken(context, token);
                LOG.debugf("Resolved the '%s' OIDC tenant based on the matching issuer '%s'", (Object)tenantId, (Object)iss);
                return tenantId;
            }
            return null;
        }

        private static boolean requiredClaimsMatch(Map<String, Set<String>> requiredClaims, JsonObject tokenJson) {
            for (Map.Entry<String, Set<String>> entry : requiredClaims.entrySet()) {
                JsonArray actualClaimValues;
                Set<String> requiredClaimSet = entry.getValue();
                String claimName = entry.getKey();
                if (requiredClaimSet.size() == 1) {
                    String actualClaimValueAsStr;
                    try {
                        actualClaimValueAsStr = tokenJson.getString(claimName);
                    }
                    catch (Exception ex) {
                        actualClaimValueAsStr = null;
                    }
                    if (actualClaimValueAsStr != null && requiredClaimSet.contains(actualClaimValueAsStr)) continue;
                }
                try {
                    actualClaimValues = tokenJson.getJsonArray(claimName);
                }
                catch (Exception e) {
                    return false;
                }
                if (actualClaimValues == null) {
                    return false;
                }
                block7: for (String requiredClaimValue : requiredClaimSet) {
                    for (int i = 0; i < actualClaimValues.size(); ++i) {
                        try {
                            String actualClaimValue = actualClaimValues.getString(i);
                            if (!requiredClaimValue.equals(actualClaimValue)) continue;
                            continue block7;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return false;
                }
            }
            return true;
        }

        private static boolean isTenantWithoutIssuer(TenantConfigContext tenantContext) {
            return IssuerBasedTenantResolver.getIssuer(tenantContext) == null;
        }

        private static boolean isTenantWithIssuer(TenantConfigContext tenantContext) {
            return IssuerBasedTenantResolver.getIssuer(tenantContext) != null;
        }

        private static IssuerBasedTenantResolver of(Map<String, TenantConfigContext> tenantConfigContexts) {
            ArrayList<TenantConfigContext> contextsWithIssuer = new ArrayList<TenantConfigContext>();
            boolean detectedTenantWithoutMetadata = false;
            HashMap<String, AtomicBoolean> tenantToRetry = new HashMap<String, AtomicBoolean>();
            for (TenantConfigContext context : tenantConfigContexts.values()) {
                if (!context.oidcConfig().tenantEnabled() || OidcUtils.isWebApp(context.oidcConfig())) continue;
                if (context.getOidcMetadata() == null) {
                    detectedTenantWithoutMetadata = true;
                    contextsWithIssuer.add(context);
                    tenantToRetry.put(context.oidcConfig().tenantId().get(), new AtomicBoolean(true));
                    continue;
                }
                if (!IssuerBasedTenantResolver.isTenantWithIssuer(context)) continue;
                contextsWithIssuer.add(context);
            }
            if (contextsWithIssuer.isEmpty()) {
                return null;
            }
            Map<String, AtomicBoolean> tenantInitStrategy = detectedTenantWithoutMetadata ? Map.copyOf(tenantToRetry) : null;
            return new IssuerBasedTenantResolver(contextsWithIssuer.toArray(new TenantConfigContext[0]), detectedTenantWithoutMetadata, tenantInitStrategy);
        }

        private static IssuerBasedTenantResolver of(Map<String, TenantConfigContext> staticTenantsConfig, TenantConfigContext defaultTenant) {
            HashMap<String, TenantConfigContext> tenantConfigContexts = new HashMap<String, TenantConfigContext>(staticTenantsConfig);
            tenantConfigContexts.put("Default", defaultTenant);
            IssuerBasedTenantResolver issuerTenantResolver = IssuerBasedTenantResolver.of(tenantConfigContexts);
            if (issuerTenantResolver != null) {
                return issuerTenantResolver;
            }
            LOG.debug((Object)"The 'quarkus.oidc.resolve-tenants-with-issuer' configuration property is set to true, but no static tenant supports this feature. To use this feature, please configure at least one static tenant with the discovered or configured issuer and set either 'service' or 'hybrid' application type");
            return null;
        }

        private static String getIssuer(TenantConfigContext tenantContext) {
            if (tenantContext.getOidcMetadata() != null) {
                String issuer = tenantContext.getOidcMetadata().getIssuer();
                if (issuer != null && IssuerBasedTenantResolver.isNotAnyIssuer(issuer)) {
                    return issuer;
                }
            } else if (tenantContext.oidcConfig() != null && tenantContext.oidcConfig().token().issuer().filter(IssuerBasedTenantResolver::isNotAnyIssuer).isPresent()) {
                return tenantContext.oidcConfig().token().issuer().get();
            }
            return null;
        }

        private static boolean isNotAnyIssuer(String issuer) {
            return !"any".equals(issuer);
        }
    }
}

