/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime;

import io.quarkus.runtime.LaunchMode;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class PortSystemProperties {
    private final Map<String, String> portPropertiesToRestore = new HashMap<String, String>();

    public void set(String subProperty, int actualPort, LaunchMode launchMode) {
        String testPropName;
        String prevTestPropPrevValue;
        String portPropertyValue = String.valueOf(actualPort);
        String portPropertyName = "quarkus." + subProperty + ".port";
        String prevPortPropertyValue = System.setProperty(portPropertyName, portPropertyValue);
        if (!Objects.equals(prevPortPropertyValue, portPropertyValue)) {
            this.portPropertiesToRestore.put(portPropertyName, prevPortPropertyValue);
        }
        if (launchMode == LaunchMode.TEST && !Objects.equals(prevTestPropPrevValue = System.setProperty(testPropName = "quarkus." + subProperty + ".test-port", portPropertyValue), portPropertyValue)) {
            this.portPropertiesToRestore.put(testPropName, prevTestPropPrevValue);
        }
        if (launchMode.isDevOrTest() && !Objects.equals(prevPortPropertyValue = System.setProperty(portPropertyName = "%" + launchMode.getDefaultProfile() + "." + portPropertyName, portPropertyValue), portPropertyValue)) {
            this.portPropertiesToRestore.put(portPropertyName, prevPortPropertyValue);
        }
    }

    public void restore() {
        this.portPropertiesToRestore.forEach((key, value) -> {
            if (value == null) {
                System.clearProperty(key);
            } else {
                System.setProperty(key, value);
            }
        });
        this.portPropertiesToRestore.clear();
    }
}

