/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.data;

import io.streamthoughts.kafka.connect.filepulse.data.DataException;
import io.streamthoughts.kafka.connect.filepulse.data.Schema;
import io.streamthoughts.kafka.connect.filepulse.data.SchemaMapper;
import io.streamthoughts.kafka.connect.filepulse.data.SchemaMapperWithValue;
import io.streamthoughts.kafka.connect.filepulse.data.Type;
import java.util.Map;
import java.util.Objects;

public class MapSchema
implements Schema {
    private final Type type;
    private Integer hash;
    private final Schema keySchema = Schema.string();
    private final Schema valueSchema;

    MapSchema(Schema valueSchema) {
        this.type = Type.MAP;
        this.valueSchema = valueSchema;
    }

    public Schema keySchema() {
        return this.keySchema;
    }

    public Schema valueSchema() {
        return this.valueSchema;
    }

    @Override
    public Type type() {
        return this.type;
    }

    @Override
    public <T> T map(SchemaMapper<T> mapper, boolean optional) {
        return mapper.map(this, optional);
    }

    @Override
    public <T> T map(SchemaMapperWithValue<T> mapper, Object object, boolean optional) {
        return mapper.map(this, (Map)object, optional);
    }

    @Override
    public boolean isResolvable() {
        return this.valueSchema.isResolvable();
    }

    @Override
    public Schema merge(Schema o) {
        if (this.equals(o)) {
            return this;
        }
        if (o instanceof MapSchema) {
            MapSchema that = (MapSchema)o;
            return new MapSchema(this.valueSchema().merge(that.valueSchema()));
        }
        throw new DataException("Cannot merge incompatible schema type " + String.valueOf((Object)this.type()) + "<>" + String.valueOf((Object)o.type()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MapSchema)) {
            return false;
        }
        MapSchema mapSchema = (MapSchema)o;
        return this.type == mapSchema.type && Objects.equals(this.hash, mapSchema.hash) && Objects.equals(this.keySchema, mapSchema.keySchema) && Objects.equals(this.valueSchema, mapSchema.valueSchema);
    }

    public int hashCode() {
        if (this.hash == null) {
            this.hash = Objects.hash(new Object[]{this.type, this.hash, this.keySchema, this.valueSchema});
        }
        return this.hash;
    }

    public String toString() {
        return "[type=" + String.valueOf((Object)this.type) + ", keySchema=" + String.valueOf(this.keySchema) + ", valueSchema=" + String.valueOf(this.valueSchema) + "]";
    }
}

