/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.data;

import io.streamthoughts.kafka.connect.filepulse.data.ArraySchema;
import io.streamthoughts.kafka.connect.filepulse.data.DataException;
import io.streamthoughts.kafka.connect.filepulse.data.LazyArraySchema;
import io.streamthoughts.kafka.connect.filepulse.data.LazyMapSchema;
import io.streamthoughts.kafka.connect.filepulse.data.MapSchema;
import io.streamthoughts.kafka.connect.filepulse.data.SchemaMapper;
import io.streamthoughts.kafka.connect.filepulse.data.SchemaMapperWithValue;
import io.streamthoughts.kafka.connect.filepulse.data.SimpleSchema;
import io.streamthoughts.kafka.connect.filepulse.data.StructSchema;
import io.streamthoughts.kafka.connect.filepulse.data.Type;
import java.util.Collection;
import java.util.Map;

public interface Schema {
    public static Schema none() {
        return EmptySchema.INSTANCE;
    }

    public static Schema of(Type type) {
        if (type.isPrimitive()) {
            return SimpleSchema.forType(type);
        }
        return null;
    }

    public static Schema string() {
        return SimpleSchema.SCHEMA_STRING;
    }

    public static Schema int64() {
        return SimpleSchema.SCHEMA_INT_64;
    }

    public static Schema int16() {
        return SimpleSchema.SCHEMA_INT_16;
    }

    public static Schema int32() {
        return SimpleSchema.SCHEMA_INT_32;
    }

    public static Schema float32() {
        return SimpleSchema.SCHEMA_FLOAT_32;
    }

    public static Schema float64() {
        return SimpleSchema.SCHEMA_FLOAT_64;
    }

    public static Schema bool() {
        return SimpleSchema.SCHEMA_BOOLEAN;
    }

    public static Schema bytes() {
        return SimpleSchema.SCHEMA_BYTES;
    }

    public static StructSchema struct() {
        return new StructSchema();
    }

    public static MapSchema map(Map<String, ?> value, Schema valueSchema) {
        return valueSchema == null ? new LazyMapSchema(value) : new MapSchema(valueSchema);
    }

    public static ArraySchema array(Schema valueSchema) {
        return new ArraySchema(valueSchema);
    }

    public static ArraySchema array(Collection<?> value, Schema valueSchema) {
        return valueSchema == null ? new LazyArraySchema(value) : new ArraySchema(valueSchema);
    }

    public Type type();

    default public boolean isResolvable() {
        return true;
    }

    public <T> T map(SchemaMapper<T> var1, boolean var2);

    public <T> T map(SchemaMapperWithValue<T> var1, Object var2, boolean var3);

    default public Schema merge(Schema that) {
        if (this.equals(that)) {
            return this;
        }
        if (this.type() == that.type()) {
            return this;
        }
        throw new DataException("Cannot merge incompatible schema type " + String.valueOf((Object)this.type()) + "<>" + String.valueOf((Object)that.type()));
    }

    public static class EmptySchema
    implements Schema {
        static EmptySchema INSTANCE = new EmptySchema();

        @Override
        public Type type() {
            return Type.NULL;
        }

        @Override
        public <T> T map(SchemaMapper<T> mapper, boolean optional) {
            throw new UnsupportedOperationException("this method is not supported for schema of type : " + String.valueOf((Object)this.type()));
        }

        @Override
        public <T> T map(SchemaMapperWithValue<T> mapper, Object object, boolean optional) {
            throw new UnsupportedOperationException("this method is not supported for schema of type : " + String.valueOf((Object)this.type()));
        }

        public String toString() {
            return "[type=" + String.valueOf((Object)Type.NULL) + "]";
        }
    }
}

