/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.data;

import io.streamthoughts.kafka.connect.filepulse.data.DataException;
import io.streamthoughts.kafka.connect.filepulse.data.LazyArraySchema;
import io.streamthoughts.kafka.connect.filepulse.data.LazyMapSchema;
import io.streamthoughts.kafka.connect.filepulse.data.Schema;
import io.streamthoughts.kafka.connect.filepulse.data.SimpleSchema;
import io.streamthoughts.kafka.connect.filepulse.data.Type;
import io.streamthoughts.kafka.connect.filepulse.data.TypedStruct;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public interface SchemaSupplier
extends Supplier<Schema> {
    public static SchemaSupplier lazy(Object object) {
        return new LazySchemaSupplier(object);
    }

    public static SchemaSupplier eager(Schema schema) {
        return new EagerSchemaSupplier(schema);
    }

    @Override
    public Schema get();

    public static class EagerSchemaSupplier
    implements SchemaSupplier {
        private final Schema schema;

        EagerSchemaSupplier(Schema schema) {
            this.schema = Objects.requireNonNull(schema, "'schema' cannot be null");
        }

        @Override
        public Schema get() {
            return this.schema;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof EagerSchemaSupplier)) {
                return false;
            }
            EagerSchemaSupplier that = (EagerSchemaSupplier)o;
            return Objects.equals(this.schema, that.schema);
        }

        public int hashCode() {
            return Objects.hash(this.schema);
        }

        public String toString() {
            return this.schema.toString();
        }
    }

    public static class LazySchemaSupplier
    implements SchemaSupplier {
        private final Object value;
        private Schema schema;

        LazySchemaSupplier(Object value) {
            this.value = value;
            if (this.value == null) {
                this.schema = Schema.none();
            }
        }

        @Override
        public Schema get() {
            this.mayInferSchemaFromValue();
            return this.schema;
        }

        private void mayInferSchemaFromValue() {
            if (this.schema == null) {
                if (this.value == null) {
                    this.schema = SimpleSchema.forType(Type.NULL);
                    return;
                }
                Type type = Type.forClass(this.value.getClass());
                if (type == null) {
                    throw new DataException("Cannot infer schema for type " + String.valueOf(this.value.getClass()));
                }
                if (type.isPrimitive()) {
                    this.schema = SimpleSchema.forType(type);
                } else if (type == Type.STRUCT) {
                    this.schema = ((TypedStruct)this.value).schema();
                } else if (type == Type.MAP) {
                    this.schema = new LazyMapSchema((Map)this.value);
                } else if (type == Type.ARRAY) {
                    this.schema = new LazyArraySchema((List)this.value);
                } else {
                    throw new DataException("Cannot infer schema for type " + String.valueOf(this.value.getClass()));
                }
            }
        }

        public boolean equals(Object o) {
            this.mayInferSchemaFromValue();
            if (this == o) {
                return true;
            }
            if (!(o instanceof LazySchemaSupplier)) {
                return false;
            }
            LazySchemaSupplier that = (LazySchemaSupplier)o;
            return Objects.equals(this.value, that.value) && Objects.equals(this.schema, that.schema);
        }

        public int hashCode() {
            this.mayInferSchemaFromValue();
            return Objects.hash(this.value, this.schema);
        }

        public String toString() {
            this.mayInferSchemaFromValue();
            return this.schema.toString();
        }
    }
}

