/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.data;

import io.streamthoughts.kafka.connect.filepulse.data.DataException;
import io.streamthoughts.kafka.connect.filepulse.data.Schema;
import io.streamthoughts.kafka.connect.filepulse.data.SchemaMapper;
import io.streamthoughts.kafka.connect.filepulse.data.SchemaMapperWithValue;
import io.streamthoughts.kafka.connect.filepulse.data.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class SimpleSchema
implements Schema {
    private static final Map<Type, Schema> SCHEMAS_KEYED_BY_TYPE = new HashMap<Type, Schema>();
    static final Schema SCHEMA_STRING = new SimpleSchema(Type.STRING);
    static final Schema SCHEMA_INT_16 = new SimpleSchema(Type.SHORT);
    static final Schema SCHEMA_INT_32 = new SimpleSchema(Type.INTEGER);
    static final Schema SCHEMA_INT_64 = new SimpleSchema(Type.LONG);
    static final Schema SCHEMA_FLOAT_32 = new SimpleSchema(Type.FLOAT);
    static final Schema SCHEMA_FLOAT_64 = new SimpleSchema(Type.DOUBLE);
    static final Schema SCHEMA_BOOLEAN = new SimpleSchema(Type.BOOLEAN);
    static final Schema SCHEMA_BYTES = new SimpleSchema(Type.BYTES);
    private final Type type;
    private Integer hash;

    static Schema forType(Type type) {
        Schema schema = SCHEMAS_KEYED_BY_TYPE.get((Object)type);
        if (schema == null) {
            throw new IllegalArgumentException("Cannot resolve simple schema  for type : " + String.valueOf((Object)type));
        }
        return schema;
    }

    private SimpleSchema(Type type) {
        Objects.requireNonNull(type, "type cannot be null");
        this.type = type;
        SCHEMAS_KEYED_BY_TYPE.put(type, this);
    }

    @Override
    public Type type() {
        return this.type;
    }

    @Override
    public <T> T map(SchemaMapper<T> mapper, boolean optional) {
        return mapper.map(this, optional);
    }

    @Override
    public <T> T map(SchemaMapperWithValue<T> mapper, Object object, boolean optional) {
        return mapper.map(this, object, optional);
    }

    @Override
    public Schema merge(Schema that) {
        if (this.equals(that)) {
            return this;
        }
        if (this.type() == that.type()) {
            return this;
        }
        if (!that.type().isPrimitive() && that.type() == Type.ARRAY) {
            return that.merge(this);
        }
        if (this.type() == Type.STRING || that.type() == Type.STRING) {
            return Schema.string();
        }
        if (this.type() == Type.LONG && that.type() == Type.INTEGER || that.type() == Type.LONG && this.type() == Type.INTEGER) {
            return Schema.int64();
        }
        if (this.type() == Type.DOUBLE && that.type().isNumber() || that.type() == Type.DOUBLE && this.type().isNumber()) {
            return Schema.float64();
        }
        throw new DataException("Cannot merge incompatible schema type " + String.valueOf((Object)this.type()) + "<>" + String.valueOf((Object)that.type()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleSchema)) {
            return false;
        }
        SimpleSchema schema = (SimpleSchema)o;
        return this.type == schema.type;
    }

    public int hashCode() {
        if (this.hash == null) {
            this.hash = Objects.hash(new Object[]{this.type});
        }
        return this.hash;
    }

    public String toString() {
        return "[type=" + String.valueOf((Object)this.type) + "]";
    }
}

