/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.data;

import io.streamthoughts.kafka.connect.filepulse.data.DataException;
import io.streamthoughts.kafka.connect.filepulse.data.TypedStruct;
import io.streamthoughts.kafka.connect.filepulse.data.TypedValue;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;

public enum Type {
    NULL(null, null){

        @Override
        public Short convert(Object o) {
            throw new UnsupportedOperationException("Cannot convert an object to type NULL");
        }

        @Override
        protected boolean isInternal() {
            return true;
        }
    }
    ,
    SHORT(Collections.singletonList(Short.class), Schema.Type.INT16){

        @Override
        public Short convert(Object o) {
            return TypedValue.any(o).getShort();
        }
    }
    ,
    INTEGER(Collections.singletonList(Integer.class), Schema.Type.INT32){

        @Override
        public Integer convert(Object o) {
            return TypedValue.any(o).getInt();
        }
    }
    ,
    LONG(Collections.singletonList(Long.class), Schema.Type.INT64){

        @Override
        public Long convert(Object o) {
            return TypedValue.any(o).getLong();
        }
    }
    ,
    FLOAT(Collections.singletonList(Float.class), Schema.Type.FLOAT32){

        @Override
        public Float convert(Object o) {
            return TypedValue.any(o).getFloat();
        }
    }
    ,
    DOUBLE(Collections.singletonList(Double.class), Schema.Type.FLOAT64){

        @Override
        public Double convert(Object o) {
            return TypedValue.any(o).getDouble();
        }
    }
    ,
    BOOLEAN(Collections.singletonList(Boolean.class), Schema.Type.BOOLEAN){

        @Override
        public Boolean convert(Object o) {
            return TypedValue.any(o).getBool();
        }
    }
    ,
    STRING(Collections.singletonList(String.class), Schema.Type.STRING){

        @Override
        public String convert(Object o) {
            return TypedValue.any(o).getString();
        }
    }
    ,
    ARRAY(Collections.singletonList(Collection.class), Schema.Type.ARRAY){

        @Override
        public Collection convert(Object o) {
            return TypedValue.any(o).getArray();
        }
    }
    ,
    MAP(Collections.singletonList(Map.class), Schema.Type.MAP){

        @Override
        public Map<String, ?> convert(Object o) {
            return TypedValue.any(o).getMap();
        }
    }
    ,
    STRUCT(Collections.singletonList(TypedStruct.class), Schema.Type.STRUCT){

        @Override
        public TypedStruct convert(Object o) {
            return TypedValue.any(o).getStruct();
        }
    }
    ,
    BYTES(Collections.emptyList(), Schema.Type.BYTES){

        public byte[] convert(Object o) {
            return TypedValue.any(o).getBytes();
        }
    };

    private static final Map<Class<?>, Type> JAVA_CLASS_TYPES;
    private final Schema.Type schemaType;
    private final Collection<Class<?>> classes;

    private Type(Collection<Class<?>> classes, Schema.Type schemaType) {
        this.classes = classes;
        this.schemaType = schemaType;
    }

    public Schema.Type schemaType() {
        return this.schemaType;
    }

    public abstract Object convert(Object var1);

    protected boolean isInternal() {
        return false;
    }

    public boolean isPrimitive() {
        switch (this) {
            case FLOAT: 
            case DOUBLE: 
            case INTEGER: 
            case LONG: 
            case BOOLEAN: 
            case STRING: 
            case BYTES: {
                return true;
            }
        }
        return false;
    }

    public boolean isNumber() {
        switch (this) {
            case FLOAT: 
            case DOUBLE: 
            case INTEGER: 
            case LONG: {
                return true;
            }
        }
        return false;
    }

    public static Type forName(String name) {
        for (Type type : Type.values()) {
            if (type.isInternal() || !type.name().equals(name) && !type.schemaType.name().equals(name)) continue;
            return type;
        }
        throw new DataException("Cannot find corresponding Type for name : " + name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Type forClass(Class<?> cls) {
        Map<Class<?>, Type> map = JAVA_CLASS_TYPES;
        synchronized (map) {
            Type type = JAVA_CLASS_TYPES.get(cls);
            if (type != null) {
                return type;
            }
            for (Map.Entry<Class<?>, Type> entry : JAVA_CLASS_TYPES.entrySet()) {
                try {
                    cls.asSubclass(entry.getKey());
                    JAVA_CLASS_TYPES.put(cls, entry.getValue());
                    return entry.getValue();
                }
                catch (ClassCastException classCastException) {
                }
            }
        }
        return null;
    }

    public static Type forConnectSchemaType(Schema.Type schemaType) {
        for (Type type : Type.values()) {
            if (type == NULL || !type.schemaType.equals((Object)schemaType)) continue;
            return type;
        }
        throw new DataException("Cannot find corresponding Type for Schema.Type : " + schemaType.getName());
    }

    static {
        JAVA_CLASS_TYPES = new HashMap();
        for (Type type : Type.values()) {
            if (type.isInternal()) continue;
            for (Class<?> typeClass : type.classes) {
                JAVA_CLASS_TYPES.put(typeClass, type);
            }
        }
    }
}

