/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.data;

import io.streamthoughts.kafka.connect.filepulse.data.DataException;
import io.streamthoughts.kafka.connect.filepulse.data.GettableByName;
import io.streamthoughts.kafka.connect.filepulse.data.LazyArraySchema;
import io.streamthoughts.kafka.connect.filepulse.data.LazyMapSchema;
import io.streamthoughts.kafka.connect.filepulse.data.Schema;
import io.streamthoughts.kafka.connect.filepulse.data.SettableByName;
import io.streamthoughts.kafka.connect.filepulse.data.StructSchema;
import io.streamthoughts.kafka.connect.filepulse.data.Type;
import io.streamthoughts.kafka.connect.filepulse.data.TypedField;
import io.streamthoughts.kafka.connect.filepulse.data.TypedValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class TypedStruct
implements GettableByName,
SettableByName<TypedStruct>,
Iterable<TypedField> {
    private final StructSchema schema;
    private final List<Object> values;

    public static TypedStruct create() {
        return new TypedStruct();
    }

    public static TypedStruct create(String name) {
        return TypedStruct.create(Schema.struct().name(name));
    }

    private static TypedStruct create(StructSchema schema) {
        return new TypedStruct(schema);
    }

    private TypedStruct() {
        this(Schema.struct());
    }

    private TypedStruct(StructSchema schema) {
        this.schema = Objects.requireNonNull(schema, "schema cannot be null");
        this.values = new LinkedList<Object>();
    }

    @Override
    public TypedStruct put(String field, Short value) {
        return this.put(field, Schema.int16(), (Object)value);
    }

    @Override
    public TypedStruct put(String field, String value) {
        return this.put(field, Schema.string(), (Object)value);
    }

    @Override
    public TypedStruct put(String field, Integer value) {
        return this.put(field, Schema.int32(), (Object)value);
    }

    @Override
    public TypedStruct put(String field, Long value) {
        return this.put(field, Schema.int64(), (Object)value);
    }

    @Override
    public TypedStruct put(String field, Double value) {
        return this.put(field, Schema.float64(), (Object)value);
    }

    @Override
    public TypedStruct put(String field, Float value) {
        return this.put(field, Schema.float32(), (Object)value);
    }

    @Override
    public TypedStruct put(String field, List value) {
        return this.put(field, new LazyArraySchema(value), (Object)value);
    }

    @Override
    public TypedStruct put(String field, Map value) {
        return this.put(field, new LazyMapSchema(value), (Object)value);
    }

    @Override
    public TypedStruct put(String field, Boolean value) {
        return this.put(field, TypedValue.bool(value));
    }

    @Override
    public TypedStruct put(String field, TypedStruct value) {
        return this.put(field, value.schema(), (Object)value);
    }

    @Override
    public <E> TypedStruct put(String field, E[] value) throws DataException {
        return this.put(field, (List)Arrays.asList(value));
    }

    @Override
    public TypedStruct put(String field, byte[] value) {
        return this.put(field, Schema.bytes(), (Object)value);
    }

    @Override
    public TypedStruct put(String field, Type type, Object value) {
        return this.put(field, Schema.of(type), value);
    }

    public TypedStruct put(TypedField field, TypedValue typed) {
        Objects.requireNonNull(field, "field can't be null");
        return this.put(field.name(), typed.schema(), typed.value());
    }

    public TypedStruct put(String field, TypedValue typed) {
        return this.put(field, typed.schema(), typed.value());
    }

    public TypedStruct put(String fieldName, Schema fieldSchema, Object fieldValue) {
        if (!this.has(fieldName)) {
            this.schema.field(fieldName, fieldSchema);
            this.values.add(fieldValue);
        } else {
            int index = this.schema.indexOf(fieldName);
            this.schema.set(fieldName, fieldSchema);
            this.values.set(index, fieldValue);
        }
        return this;
    }

    @Override
    public boolean has(String name) {
        return this.schema.field(name) != null;
    }

    public TypedValue get(TypedField field) {
        Objects.requireNonNull(field, "field cannot be null");
        return this.get(field.name());
    }

    @Override
    public TypedValue get(String name) {
        Objects.requireNonNull(name, "name cannot be null");
        TypedField field = this.lookupField(name);
        Object o = this.values.get(field.index());
        return TypedValue.of(o, field.schema());
    }

    @Override
    public String getString(String field) {
        return (String)this.getCheckedType(field, Type.STRING);
    }

    @Override
    public Short getShort(String field) {
        return (Short)this.getCheckedType(field, Type.SHORT);
    }

    @Override
    public Boolean getBoolean(String field) throws DataException {
        return (Boolean)this.getCheckedType(field, Type.BOOLEAN);
    }

    @Override
    public Integer getInt(String field) {
        return (Integer)this.getCheckedType(field, Type.INTEGER);
    }

    @Override
    public Long getLong(String field) {
        return (Long)this.getCheckedType(field, Type.LONG);
    }

    @Override
    public Float getFloat(String field) throws DataException {
        return (Float)this.getCheckedType(field, Type.FLOAT);
    }

    @Override
    public Double getDouble(String field) {
        return (Double)this.getCheckedType(field, Type.DOUBLE);
    }

    public <T> List<T> getArray(String field) {
        return (List)this.getCheckedType(field, Type.ARRAY);
    }

    @Override
    public TypedStruct getStruct(String field) {
        return (TypedStruct)this.getCheckedType(field, Type.STRUCT);
    }

    @Override
    public <K, V> Map<K, V> getMap(String field) throws DataException {
        return (Map)this.getCheckedType(field, Type.MAP);
    }

    public TypedStruct rename(String path, String newField) {
        TypedValue child;
        String[] split;
        if (this.has(path)) {
            this.schema.rename(path, newField);
            return this;
        }
        if (TypedStruct.isDotPropertyAccessPath(path) && this.has((split = path.split("\\.", 2))[0]) && (child = this.get(split[0])).schema().type() == Type.STRUCT) {
            return child.getStruct().rename(split[1], newField);
        }
        return this;
    }

    public TypedValue remove(String path) {
        TypedValue child;
        String[] split;
        if (this.has(path)) {
            TypedValue value = this.get(path);
            TypedField removed = this.schema.remove(path);
            if (removed != null) {
                this.values.remove(removed.index());
            }
            return value;
        }
        if (TypedStruct.isDotPropertyAccessPath(path) && this.has((split = path.split("\\.", 2))[0]) && (child = this.get(split[0])).schema().type() == Type.STRUCT) {
            TypedStruct childStruct = child.getStruct();
            TypedValue removed = childStruct.remove(split[1]);
            if (removed != null && childStruct.values.isEmpty()) {
                this.remove(split[0]);
            }
            return removed;
        }
        return null;
    }

    public boolean exists(String path) {
        Objects.requireNonNull(path, "path cannot be null");
        return this.find(path) != null;
    }

    public TypedValue find(String path) {
        TypedValue child;
        String[] split;
        Objects.requireNonNull(path, "path cannot be null");
        if (this.has(path)) {
            return this.get(path);
        }
        if (TypedStruct.isDotPropertyAccessPath(path) && this.has((split = path.split("\\.", 2))[0]) && (child = this.get(split[0])).schema().type() == Type.STRUCT) {
            return child.getStruct().find(split[1]);
        }
        return null;
    }

    public TypedStruct insert(String path, Object value) {
        if (path == null || path.isEmpty()) {
            throw new IllegalArgumentException("Cannot insert value given null or empty path");
        }
        this.doInsert(path, value instanceof TypedValue ? (TypedValue)value : TypedValue.any(value));
        return this;
    }

    private void doInsert(String path, TypedValue value) {
        if (TypedStruct.isDotPropertyAccessPath(path)) {
            TypedStruct child;
            String[] split = path.split("\\.", 2);
            String field = split[0];
            String remaining = split[1];
            if (this.has(field)) {
                child = this.getStruct(field);
            } else {
                child = new TypedStruct();
                this.put(field, child);
            }
            child.doInsert(remaining, value);
        } else {
            this.put(path, value);
        }
    }

    private static boolean isDotPropertyAccessPath(String name) {
        return name.contains(".");
    }

    public TypedValue first(String fieldName) {
        Collection array;
        TypedField field = this.field(fieldName);
        if (field.type() == Type.ARRAY && !(array = this.getArray(fieldName)).isEmpty()) {
            return TypedValue.any(array.get(0));
        }
        return this.get(fieldName);
    }

    public StructSchema schema() {
        return this.schema;
    }

    public TypedField field(String name) {
        Objects.requireNonNull(name, "name cannot be null");
        return this.lookupField(name);
    }

    private TypedField lookupField(String name) {
        TypedField field = this.schema.field(name);
        if (field == null) {
            throw new DataException(name + " is not a valid field name");
        }
        return field;
    }

    private <T> T getCheckedType(String name, Type type) {
        TypedValue typed = this.get(name);
        if (typed.type() == type) {
            return typed.value();
        }
        throw new DataException("Field '" + name + "' is not of type " + String.valueOf((Object)type) + ", actual type is " + String.valueOf((Object)typed.type()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TypedStruct)) {
            return false;
        }
        TypedStruct that = (TypedStruct)o;
        return Objects.equals(this.schema, that.schema) && Objects.equals(this.values, that.values);
    }

    public int hashCode() {
        return Objects.hash(this.schema, this.values);
    }

    public String toString() {
        return StreamSupport.stream(this.schema.spliterator(), false).map(field -> {
            TypedValue value = this.get((TypedField)field);
            return "name: " + field.name() + ", type: " + String.valueOf((Object)value.schema().type()) + ", value: " + String.valueOf(value.value());
        }).collect(Collectors.joining(", ", "[", "]"));
    }

    @Override
    public Iterator<TypedField> iterator() {
        return this.schema.iterator();
    }
}

