/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.data.internal;

import io.streamthoughts.kafka.connect.filepulse.data.DataException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;

public class TypeConverter
implements Serializable {
    private static final String BOOLEAN_TRUE = "true";
    private static final String BOOLEAN_FALSE = "false";
    private static final String MIN_LONG_STR_NO_SIGN = String.valueOf(Long.MIN_VALUE).substring(1);
    private static final String MAX_LONG_STR = String.valueOf(Long.MAX_VALUE);
    private static final String Digits = "(\\p{Digit}+)";
    private static final String HexDigits = "(\\p{XDigit}+)";
    private static final String Exp = "[eE][+-]?(\\p{Digit}+)";
    private static final String fpRegex = "[\\x00-\\x20]*[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*";
    private static final Pattern DOUBLE_REGEX_MATCHER = Pattern.compile("[\\x00-\\x20]*[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*");

    public static Collection getArray(Object value) throws IllegalArgumentException {
        Objects.requireNonNull(value, "value can't be null");
        if (Collection.class.isAssignableFrom(value.getClass())) {
            return (Collection)value;
        }
        if (value instanceof Object[]) {
            return Arrays.asList((Object[])value);
        }
        throw new DataException(String.format("'%s' is not assignable to Collection: \"%s\"", value.getClass(), value));
    }

    public static Boolean getBool(Object value) throws IllegalArgumentException {
        Boolean result = null;
        if (value == null) {
            result = false;
        }
        if (value instanceof String) {
            char digit;
            String s = (String)value;
            result = s.length() == 1 && Character.isDigit(s.charAt(0)) ? Boolean.valueOf((digit = s.charAt(0)) > '\u0000') : Boolean.valueOf(s.equalsIgnoreCase(BOOLEAN_TRUE) || s.equalsIgnoreCase("yes") || s.equalsIgnoreCase("y"));
        }
        if (value instanceof Boolean) {
            result = (Boolean)value;
        }
        if (result == null) {
            throw new DataException(String.format("Cannot parse boolean content from \"%s\"", value));
        }
        return result;
    }

    public static Short getShort(Object value) throws IllegalArgumentException {
        Objects.requireNonNull(value, "value can't be null");
        if (value instanceof String && TypeConverter.isIntegerNumber((String)value)) {
            return new BigDecimal(value.toString()).shortValue();
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.shortValue();
        }
        throw new DataException(String.format("Cannot parse 32-bits int content from \"%s\"", value));
    }

    public static Integer getInt(Object value) throws IllegalArgumentException {
        Objects.requireNonNull(value, "value can't be null");
        if (value instanceof String && TypeConverter.isIntegerNumber((String)value)) {
            return new BigDecimal(value.toString()).intValue();
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.intValue();
        }
        throw new DataException(String.format("Cannot parse 32-bits int content from \"%s\"", value));
    }

    public static Long getLong(Object value) throws IllegalArgumentException {
        String trimmed;
        Objects.requireNonNull(value, "value can't be null");
        if (value instanceof String && TypeConverter.isIntegerNumber(trimmed = ((String)value).trim())) {
            return new BigDecimal(trimmed).longValue();
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.longValue();
        }
        throw new DataException(String.format("Cannot parse 64-bits long content from \"%s\"", value));
    }

    public static Float getFloat(Object value) throws IllegalArgumentException {
        Objects.requireNonNull(value, "value can't be null");
        if (value instanceof String) {
            return TypeConverter.getBigDecimal(value).map(BigDecimal::floatValue).orElseThrow(() -> new DataException(String.format("Cannot parse 64-bits double content from \"%s\"", value)));
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return Float.valueOf(number.floatValue());
        }
        throw new DataException(String.format("Cannot parse 32-bits float content from \"%s\"", value));
    }

    private static Optional<BigDecimal> getBigDecimal(Object value) {
        try {
            return Optional.of(new BigDecimal(value.toString().replace(",", ".")));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    public static Double getDouble(Object value) throws IllegalArgumentException {
        Objects.requireNonNull(value, "value can't be null");
        if (value instanceof String) {
            return TypeConverter.getBigDecimal(value).map(BigDecimal::doubleValue).orElseThrow(() -> new DataException(String.format("Cannot parse 64-bits double content from \"%s\"", value)));
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.doubleValue();
        }
        throw new DataException(String.format("Cannot parse 64-bits double content from \"%s\"", value));
    }

    public static Date getDate(Object value) throws IllegalArgumentException {
        Objects.requireNonNull(value, "value can't be null");
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return new Date(number.longValue());
        }
        if (value instanceof String && TypeConverter.isIntegerNumber((String)value)) {
            return new Date(Long.parseLong((String)value));
        }
        throw new DataException(String.format("Cannot parse Date content from \"%s\"", value));
    }

    public static String getString(Object value) {
        if (value instanceof ByteBuffer) {
            return StandardCharsets.UTF_8.decode((ByteBuffer)value).toString();
        }
        return value != null ? value.toString() : null;
    }

    public static byte[] getBytes(Object value) {
        if (value instanceof ByteBuffer) {
            return ((ByteBuffer)value).array();
        }
        if (value instanceof String) {
            return ((String)value).getBytes(StandardCharsets.UTF_8);
        }
        if (value.getClass().isArray()) {
            return (byte[])value;
        }
        throw new DataException(String.format("Cannot parse byte[] from \"%s\"", value));
    }

    public static BigDecimal getDecimal(Object value) {
        Objects.requireNonNull(value, "value can't be null");
        String result = null;
        if (value instanceof Double) {
            result = String.valueOf(value);
        }
        if (value instanceof Integer) {
            result = String.valueOf(value);
        }
        if (value instanceof String) {
            result = (String)value;
        }
        if (result == null) {
            throw new DataException(String.format("Cannot parse decimal content from \"%s\"", value));
        }
        if (result.trim().length() == 0) {
            return null;
        }
        return TypeConverter.getBigDecimal(value).orElseThrow(() -> new DataException(String.format("Cannot parse decimal content from \"%s\"", value)));
    }

    public static boolean isBooleanString(String text) {
        return BOOLEAN_TRUE.equalsIgnoreCase(text) || BOOLEAN_FALSE.equalsIgnoreCase(text);
    }

    public static boolean isIntegerNumber(String text) {
        int start;
        if (text.isEmpty()) {
            return false;
        }
        char c = text.charAt(0);
        int n = start = c == '-' ? 1 : 0;
        if (start == 1 && text.length() == 1) {
            return false;
        }
        for (int i = start; i < text.length(); ++i) {
            c = text.charAt(i);
            if (Character.digit(c, 10) >= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isDoubleNumber(String text) {
        return text != null && DOUBLE_REGEX_MATCHER.matcher(text).matches();
    }

    public static boolean isInLongRange(String s) {
        String cmp;
        boolean negative = s.charAt(0) == '-';
        String string = cmp = negative ? MIN_LONG_STR_NO_SIGN : MAX_LONG_STR;
        if (negative) {
            s = s.substring(1);
        }
        int cmpLen = cmp.length();
        int alen = s.length();
        if (alen < cmpLen) {
            return true;
        }
        if (alen > cmpLen) {
            return false;
        }
        for (int i = 0; i < cmpLen; ++i) {
            int diff = s.charAt(i) - cmp.charAt(i);
            if (diff == 0) continue;
            return diff < 0;
        }
        return true;
    }
}

