/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.data.merger;

import io.streamthoughts.kafka.connect.filepulse.data.ArraySchema;
import io.streamthoughts.kafka.connect.filepulse.data.DataException;
import io.streamthoughts.kafka.connect.filepulse.data.FieldPaths;
import io.streamthoughts.kafka.connect.filepulse.data.Schema;
import io.streamthoughts.kafka.connect.filepulse.data.Type;
import io.streamthoughts.kafka.connect.filepulse.data.TypedField;
import io.streamthoughts.kafka.connect.filepulse.data.TypedStruct;
import io.streamthoughts.kafka.connect.filepulse.data.TypedValue;
import io.streamthoughts.kafka.connect.filepulse.data.merger.TypeValueMerger;
import java.util.LinkedList;
import java.util.Set;

public class DefaultTypeValueMerger
implements TypeValueMerger {
    @Override
    public TypedStruct merge(TypedStruct left, TypedStruct right, Set<String> overwrite) {
        return DefaultTypeValueMerger.mergeObjects(left, right, FieldPaths.from(overwrite));
    }

    private static TypedStruct mergeObjects(TypedStruct left, TypedStruct right, FieldPaths overwrite) {
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        TypedStruct struct = TypedStruct.create();
        for (TypedField leftField : left) {
            TypedValue merged;
            String fieldName = leftField.name();
            TypedValue leftValue = left.get(leftField);
            if (!right.has(fieldName)) {
                struct.put(fieldName, leftValue);
                continue;
            }
            boolean isOverwrite = overwrite.anyMatches(fieldName);
            if (isOverwrite) continue;
            TypedField rightField = right.field(fieldName);
            DefaultTypeValueMerger.checkIfTypesAreCompatibleForMerge(leftField, rightField);
            TypedValue rightValue = right.get(rightField);
            if (leftField.type() == Type.STRUCT) {
                TypedStruct mergedStruct = DefaultTypeValueMerger.mergeObjects(leftValue.getStruct(), rightValue.getStruct(), overwrite.next(fieldName));
                merged = TypedValue.struct(mergedStruct);
            } else {
                merged = DefaultTypeValueMerger.merge(leftValue, rightValue);
            }
            struct.put(fieldName, merged);
        }
        for (TypedField f : right) {
            if (struct.has(f.name())) continue;
            struct.put(f, right.get(f));
        }
        return struct;
    }

    private static TypedValue merge(TypedValue left, TypedValue right) {
        LinkedList values = new LinkedList();
        if (left.type() == Type.ARRAY) {
            values.addAll(left.getArray());
        } else {
            values.add(left.value());
        }
        if (right.type() == Type.ARRAY) {
            values.addAll(right.getArray());
        } else {
            values.add(right.value());
        }
        return TypedValue.array(values, left.schema());
    }

    private static void checkIfTypesAreCompatibleForMerge(TypedField left, TypedField right) {
        String name = left.name();
        Schema leftSchema = left.schema();
        Schema rightSchema = right.schema();
        if (left.type() == Type.ARRAY && right.type() == Type.ARRAY) {
            Schema valueSchemaRight;
            Schema valueSchemaLeft = ((ArraySchema)leftSchema).valueSchema();
            if (DefaultTypeValueMerger.isTypeNotEqual(valueSchemaLeft, valueSchemaRight = ((ArraySchema)rightSchema).valueSchema())) {
                throw new DataException(String.format("Cannot merge fields '%s' of type array with different value types : Array[%s]<>Array[%s]", new Object[]{name, valueSchemaLeft.type(), valueSchemaRight.type()}));
            }
            return;
        }
        if (left.type() == Type.ARRAY) {
            Schema valueSchemaLeft = ((ArraySchema)leftSchema).valueSchema();
            if (DefaultTypeValueMerger.isTypeNotEqual(valueSchemaLeft, rightSchema)) {
                throw new DataException(String.format("Cannot merge fields '%s' with different array value types : Array[%s]<>%s", new Object[]{name, valueSchemaLeft.type(), rightSchema.type()}));
            }
            return;
        }
        if (right.type() == Type.ARRAY) {
            Schema valueSchemaRight = ((ArraySchema)rightSchema).valueSchema();
            if (DefaultTypeValueMerger.isTypeNotEqual(leftSchema, valueSchemaRight)) {
                throw new DataException(String.format("Cannot merge fields '%s' with different array value types : %s<>Array[%s]", new Object[]{name, leftSchema.type(), valueSchemaRight.type()}));
            }
            return;
        }
        if (DefaultTypeValueMerger.isTypeNotEqual(leftSchema, rightSchema)) {
            throw new DataException(String.format("Cannot merge fields '%s' with different types : %s<>%s", new Object[]{name, leftSchema.type(), rightSchema.type()}));
        }
    }

    private static boolean isTypeNotEqual(Schema left, Schema right) {
        return left != null && right != null && left.type() != right.type();
    }
}

