/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.internal;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public final class DateTimeParser {
    private static final Function<ZoneId, ZonedDateTime> DEFAULT_ZONED_DATE_TIME = zid -> ZonedDateTime.of(1970, 1, 1, 0, 0, 0, 0, zid);
    private final DateTimeFormatter formatter;

    public DateTimeParser(String pattern) {
        this(pattern, Locale.ROOT);
    }

    public DateTimeParser(String pattern, Locale locale) {
        Objects.requireNonNull(pattern, "'pattern' should not be null");
        Objects.requireNonNull(pattern, "'locale' should not be null");
        this.formatter = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern(pattern).toFormatter(locale);
    }

    public ZonedDateTime parse(String datetime, ZoneId zoneId) {
        TemporalAccessor parsed = this.formatter.parse(datetime);
        ZoneId parsedZoneId = TemporalQueries.zone().queryFrom(parsed);
        ZoneId atZonedId = Optional.ofNullable(parsedZoneId).orElse(zoneId);
        ZonedDateTime resolved = DEFAULT_ZONED_DATE_TIME.apply(atZonedId);
        for (ChronoField override : ChronoField.values()) {
            if (!parsed.isSupported(override)) continue;
            long value = parsed.getLong(override);
            resolved = resolved.with(override, value);
        }
        return resolved;
    }
}

