/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.internal;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum Encoding {
    HEX(Encoding::bytesToHex),
    UTF8(value -> new String((byte[])value, StandardCharsets.UTF_8)),
    ASCII(value -> new String((byte[])value, StandardCharsets.US_ASCII)),
    BASE64(value -> Base64.getEncoder().encodeToString((byte[])value));

    private final Function<byte[], String> encoder;
    private static final byte[] HEX_ARRAY;

    private Encoding(Function<byte[], String> encoder) {
        this.encoder = Objects.requireNonNull(encoder, "'encode' should not be null");
    }

    public static Encoding from(String value) {
        for (Encoding encoding : Encoding.values()) {
            if (!value.equalsIgnoreCase(encoding.name())) continue;
            return encoding;
        }
        String supported = Arrays.stream(Encoding.values()).map(Enum::name).map(String::toLowerCase).collect(Collectors.joining(", ", "[ ", " ]"));
        throw new IllegalArgumentException("Unknown encoding type '" + value + "'. Supported encoding types are: " + supported + ".");
    }

    public String encode(byte[] bytes) {
        return this.encoder.apply(bytes);
    }

    private static String bytesToHex(byte[] bytes) {
        byte[] hexChars = new byte[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars, StandardCharsets.UTF_8);
    }

    static {
        HEX_ARRAY = "0123456789ABCDEF".getBytes(StandardCharsets.US_ASCII);
    }
}

