/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.internal;

import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

public class Environment {
    private final SystemContext system = new SystemContext(System.getenv(), System.getProperties());

    public SystemContext system() {
        return this.system;
    }

    public static class SystemContext {
        private final Map<String, String> env;
        private final Map<String, String> props;

        SystemContext(Map<String, String> env, Properties props) {
            this.env = env;
            this.props = SystemContext.fromProperties(props);
        }

        public Map<String, String> getEnv() {
            return this.env;
        }

        public Map<String, String> getProps() {
            return this.props;
        }

        private static Map<String, String> fromProperties(Properties props) {
            LinkedHashMap<String, String> builder = new LinkedHashMap<String, String>();
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                builder.put(key, props.getProperty(key));
            }
            return builder;
        }
    }
}

