/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.internal;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.Optional;

public class IOUtils {
    public static Optional<Long> getUnixInode(File file) {
        Objects.requireNonNull(file, "file can't be null");
        try {
            Long inode = (Long)Files.getAttribute(file.toPath(), "unix:ino", new LinkOption[0]);
            return Optional.ofNullable(inode);
        }
        catch (IOException | IllegalArgumentException | UnsupportedOperationException e) {
            return Optional.empty();
        }
    }

    public static void createParentIfNotExists(Path targetPath) throws IOException {
        Objects.requireNonNull(targetPath, "'targetPath' cannot be null");
        Path parent = targetPath.getParent();
        if (!Files.exists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
    }

    public static boolean isAbsolute(String to) {
        return to.startsWith(File.separator) || new File(to).isAbsolute();
    }

    public static String getRelativePathFrom(String basePath, File file) {
        Objects.requireNonNull(basePath, "basePath cannot be null");
        Objects.requireNonNull(file, "file cannot be null");
        return new File(basePath).toURI().relativize(file.getParentFile().toURI()).getPath();
    }

    public static String getParentDirectoryPath(String name) {
        int sepIndex = -1;
        if (name.contains(File.separator)) {
            sepIndex = name.lastIndexOf(File.separator);
        }
        return sepIndex == -1 ? null : name.substring(0, sepIndex);
    }

    public static String getNameWithoutExtension(File file) {
        Objects.requireNonNull(file, "file cannot be null");
        String filename = file.getName();
        int dotIndex = filename.lastIndexOf(".");
        return dotIndex == -1 ? filename : filename.substring(0, dotIndex);
    }

    public static File createDirectoryFromFile(File file) throws IOException {
        Objects.requireNonNull(file, "file cannot be null");
        Path unzipPath = Paths.get(file.getParentFile().getCanonicalPath(), IOUtils.getNameWithoutExtension(file));
        if (!Files.exists(unzipPath, new LinkOption[0])) {
            Files.createDirectories(unzipPath, new FileAttribute[0]);
        }
        return unzipPath.toFile();
    }
}

