/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.internal;

import java.util.Objects;

public class KeyValuePair<K, V> {
    public final K key;
    public final V value;

    public static KeyValuePair<String, String> parse(String str, String separator) {
        String[] split = str.split(separator);
        return KeyValuePair.of(split[0], split[1]);
    }

    public static <K, V> KeyValuePair<K, V> of(K key, V value) {
        return new KeyValuePair<K, V>(key, value);
    }

    private KeyValuePair(K key, V value) {
        this.key = key;
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeyValuePair)) {
            return false;
        }
        KeyValuePair that = (KeyValuePair)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    public String toString() {
        return "[key=" + String.valueOf(this.key) + ", value=" + String.valueOf(this.value) + "]";
    }
}

