/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.internal;

import java.util.Arrays;
import java.util.Locale;
import java.util.MissingResourceException;

public class LocaleUtils {
    public static Locale parse(String localeStr) {
        String separator = LocaleUtils.separatorFor(localeStr);
        String[] parts = localeStr.split(separator, -1);
        Locale locale = LocaleUtils.buildLocale(parts);
        LocaleUtils.checkIsValidISOLanguage(parts, locale);
        LocaleUtils.checkIsValidISOCountry(parts, locale);
        return locale;
    }

    private static String separatorFor(String localeStr) {
        char c;
        int sep = 45;
        for (int i = 0; i < localeStr.length() && (c = localeStr.charAt(i)) != '-'; ++i) {
            if (c != '_') continue;
            sep = 95;
            break;
        }
        return String.valueOf((char)sep);
    }

    private static void checkIsValidISOCountry(String[] parts, Locale locale) {
        try {
            locale.getISO3Country();
        }
        catch (MissingResourceException e) {
            throw new IllegalArgumentException("Cannot build Locale for unknown country : " + parts[0], e);
        }
    }

    private static void checkIsValidISOLanguage(String[] parts, Locale locale) {
        try {
            locale.getISO3Language();
        }
        catch (MissingResourceException e) {
            throw new IllegalArgumentException("Cannot build Locale for unknown language: " + parts[1], e);
        }
    }

    private static Locale buildLocale(String[] parts) {
        switch (parts.length) {
            case 3: {
                return new Locale(parts[0], parts[1], parts[2]);
            }
            case 2: {
                return new Locale(parts[0], parts[1]);
            }
            case 1: {
                if ("ROOT".equalsIgnoreCase(parts[0])) {
                    return Locale.ROOT;
                }
                return new Locale(parts[0]);
            }
        }
        throw new IllegalArgumentException(String.format("Locales can have at most 3 parts but got %d : %s", parts.length, Arrays.asList(parts)));
    }
}

