/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.reader;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class RecordsIterable<T>
implements Iterable<T> {
    private final List<T> records;

    public static <T> RecordsIterable<T> empty() {
        return new RecordsIterable(Collections.emptyList());
    }

    @SafeVarargs
    public static <T> RecordsIterable<T> of(T ... records) {
        return new RecordsIterable<T>(records);
    }

    @SafeVarargs
    public RecordsIterable(T ... records) {
        this(Arrays.asList(records));
    }

    public RecordsIterable(List<T> records) {
        this.records = new ArrayList<T>((Collection)Objects.requireNonNull(records, "records cannot be null"));
    }

    public int size() {
        return this.records.size();
    }

    public boolean isEmpty() {
        return this.records.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.records.iterator();
    }

    public T last() {
        return !this.isEmpty() ? (T)this.records.get(this.records.size() - 1) : null;
    }

    @Override
    public Spliterator<T> spliterator() {
        return Spliterators.spliterator(this.records, 0);
    }

    public List<T> collect() {
        return this.records;
    }

    public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public String toString() {
        return this.records.toString();
    }
}

