/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.schema;

import io.streamthoughts.kafka.connect.filepulse.schema.CyclicSchemaWrapper;
import io.streamthoughts.kafka.connect.filepulse.schema.SchemaMerger;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;

public class SchemaContext {
    final Map<String, CyclicSchemaWrapper> connectSchemaReferences = new HashMap<String, CyclicSchemaWrapper>();

    public Schema buildSchemaWithCyclicSchemaWrapper(Schema connectSchema) {
        String schemaName = connectSchema.name();
        if (schemaName != null) {
            CyclicSchemaWrapper wrapper;
            if (this.connectSchemaReferences.containsKey(schemaName)) {
                wrapper = this.connectSchemaReferences.remove(schemaName);
                wrapper.schema(SchemaMerger.merge(wrapper.schema(), connectSchema, this));
            } else {
                wrapper = new CyclicSchemaWrapper(connectSchema);
                this.connectSchemaReferences.put(schemaName, wrapper);
            }
            return wrapper;
        }
        return connectSchema;
    }
}

