/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.schema;

import io.streamthoughts.kafka.connect.filepulse.data.DataException;
import io.streamthoughts.kafka.connect.filepulse.schema.SchemaContext;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;

public class SchemaMerger
implements BiFunction<Schema, Schema, Schema> {
    @Override
    public Schema apply(Schema left, Schema right) {
        return SchemaMerger.merge(left, right);
    }

    public static Schema merge(Schema left, Schema right) {
        return SchemaMerger.merge(left, right, new SchemaContext());
    }

    public static Schema merge(Schema left, Schema right, SchemaContext context) {
        if (left.equals(right)) {
            return left;
        }
        if (left.type() == Schema.Type.ARRAY || right.type() == Schema.Type.ARRAY) {
            return SchemaMerger.mergeArray(left, right, context);
        }
        if (left.type() == Schema.Type.STRUCT && right.type() == Schema.Type.STRUCT) {
            return SchemaMerger.mergeStruct(left, right, context);
        }
        if (left.type() == Schema.Type.MAP && right.type() == Schema.Type.MAP) {
            return SchemaMerger.mergeMap(left, right, context);
        }
        if (left.type() == right.type()) {
            return left;
        }
        if (left.type() == Schema.Type.STRING && right.type().isPrimitive() || right.type() == Schema.Type.STRING && left.type().isPrimitive()) {
            return SchemaMerger.mergeMetadata(left, right, SchemaBuilder.string());
        }
        if (left.type() == Schema.Type.INT64 && right.type() == Schema.Type.INT32 || right.type() == Schema.Type.INT64 && left.type() == Schema.Type.INT32) {
            return SchemaMerger.mergeMetadata(left, right, SchemaBuilder.int64());
        }
        if (left.type() == Schema.Type.FLOAT64 && SchemaMerger.isNumber(right.type()) || right.type() == Schema.Type.FLOAT64 && SchemaMerger.isNumber(left.type())) {
            return SchemaMerger.mergeMetadata(left, right, SchemaBuilder.float64());
        }
        throw new DataException("Cannot merge incompatible schema type " + String.valueOf(left.type()) + "<>" + String.valueOf(right.type()));
    }

    private static Schema mergeMap(Schema left, Schema right, SchemaContext context) {
        SchemaBuilder merged = SchemaBuilder.map((Schema)SchemaMerger.merge(left.keySchema(), right.keySchema(), context), (Schema)SchemaMerger.merge(left.valueSchema(), right.valueSchema(), context));
        return SchemaMerger.mergeMetadata(left, right, merged).build();
    }

    private static Schema mergeArray(Schema left, Schema right, SchemaContext context) {
        Schema valueSchema = left.type() == Schema.Type.ARRAY && right.type() == Schema.Type.ARRAY ? SchemaMerger.merge(left.valueSchema(), right.valueSchema(), context) : (left.type() == Schema.Type.ARRAY ? SchemaMerger.merge(left.valueSchema(), right, context) : SchemaMerger.merge(left, right.valueSchema(), context));
        return SchemaBuilder.array((Schema)valueSchema).optional().defaultValue(null).build();
    }

    private static Schema mergeStruct(Schema left, Schema right, SchemaContext context) {
        if (left.name() != null && right.name() != null && !Objects.equals(left.name(), right.name())) {
            throw new DataException("Cannot merge two schemas wih different name " + left.name() + "<>" + right.name());
        }
        SchemaBuilder merged = SchemaMerger.mergeMetadata(left, right, new SchemaBuilder(Schema.Type.STRUCT));
        HashMap<String, Schema> fieldSchemas = new HashMap<String, Schema>();
        Map<String, Schema> remaining = left.fields().stream().collect(Collectors.toMap(Field::name, Field::schema));
        for (Field rightField : right.fields()) {
            String name = rightField.name();
            if (!remaining.containsKey(name)) {
                fieldSchemas.put(name, rightField.schema());
                continue;
            }
            Schema leftSchema = remaining.remove(name);
            try {
                fieldSchemas.put(name, SchemaMerger.merge(leftSchema, rightField.schema(), context));
            }
            catch (Exception e) {
                throw new DataException("Failed to merge schemas for field '" + name + "'. ", e);
            }
        }
        fieldSchemas.putAll(remaining);
        fieldSchemas.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(it -> merged.field((String)it.getKey(), context.buildSchemaWithCyclicSchemaWrapper((Schema)it.getValue())));
        return context.buildSchemaWithCyclicSchemaWrapper(merged.build());
    }

    private static SchemaBuilder mergeMetadata(Schema left, Schema right, SchemaBuilder merged) {
        merged.name(left.name() != null ? left.name() : right.name());
        merged.doc(left.doc() != null ? left.doc() : right.doc());
        if (left.isOptional() || right.isOptional()) {
            merged.optional();
        }
        if (left.defaultValue() != null) {
            merged.defaultValue(left.defaultValue());
        } else if (right.defaultValue() != null) {
            merged.defaultValue(right.defaultValue());
        }
        HashMap parameters = new HashMap();
        if (left.parameters() != null) {
            parameters.putAll(left.parameters());
        }
        if (right.parameters() != null) {
            parameters.putAll(right.parameters());
        }
        if (!parameters.isEmpty()) {
            merged.parameters(parameters);
        }
        return merged;
    }

    private static boolean isInteger(Schema.Type type) {
        return type == Schema.Type.INT8 || type == Schema.Type.INT16 || type == Schema.Type.INT32 || type == Schema.Type.INT64;
    }

    private static boolean isNumber(Schema.Type type) {
        return SchemaMerger.isInteger(type) || Arrays.asList(Schema.Type.FLOAT32, Schema.Type.FLOAT64).contains(type);
    }
}

