/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.source;

import io.streamthoughts.kafka.connect.filepulse.source.FileRecord;
import io.streamthoughts.kafka.connect.filepulse.source.FileRecordOffset;
import java.util.Objects;

public abstract class AbstractFileRecord<T>
implements FileRecord<T> {
    private final T value;
    private final FileRecordOffset offset;

    AbstractFileRecord(FileRecordOffset offset, T value) {
        this.offset = Objects.requireNonNull(offset, "offset cannot be null");
        this.value = value;
    }

    @Override
    public T value() {
        return this.value;
    }

    @Override
    public FileRecordOffset offset() {
        return this.offset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractFileRecord)) {
            return false;
        }
        AbstractFileRecord that = (AbstractFileRecord)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.offset, that.offset);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.offset);
    }

    public String toString() {
        return "[value=" + String.valueOf(this.value) + ", offset=" + String.valueOf(this.offset) + "]";
    }
}

