/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.source;

import io.streamthoughts.kafka.connect.filepulse.data.TypedStruct;
import io.streamthoughts.kafka.connect.filepulse.reader.FileInputIterator;
import io.streamthoughts.kafka.connect.filepulse.reader.FileInputReader;
import io.streamthoughts.kafka.connect.filepulse.reader.RecordsIterable;
import io.streamthoughts.kafka.connect.filepulse.source.FileObjectContext;
import io.streamthoughts.kafka.connect.filepulse.source.FileObjectKey;
import io.streamthoughts.kafka.connect.filepulse.source.FileObjectMeta;
import io.streamthoughts.kafka.connect.filepulse.source.FileObjectOffset;
import io.streamthoughts.kafka.connect.filepulse.source.FileRecord;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegateFileInputIterator
implements FileInputIterator<FileRecord<TypedStruct>> {
    private static final Logger LOG = LoggerFactory.getLogger(DelegateFileInputIterator.class);
    private final URI objectURI;
    private final FileObjectKey key;
    private final FileInputReader reader;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private FileInputIterator<FileRecord<TypedStruct>> iterator;

    DelegateFileInputIterator(FileObjectKey key, URI objectURI, FileInputReader reader) {
        this.key = Objects.requireNonNull(key, "'key' should not be null");
        this.objectURI = Objects.requireNonNull(objectURI, "'objectURI' can't be null");
        this.reader = Objects.requireNonNull(reader, "'reader' can't be null");
    }

    public FileObjectMeta getMetadata() {
        return this.reader.getObjectMetadata(this.objectURI);
    }

    public URI getObjectURI() {
        return this.objectURI;
    }

    public void open() {
        if (this.isOpen()) {
            throw new IllegalStateException("Iterator is already open");
        }
        LOG.info("Opening new iterator for: {}", (Object)this.objectURI);
        this.iterator = this.reader.newIterator(this.objectURI);
    }

    boolean isOpen() {
        return this.iterator != null && !this.iterator.isClosed();
    }

    boolean isValid() {
        return this.reader.canBeRead(this.objectURI);
    }

    public FileObjectKey key() {
        return this.key;
    }

    @Override
    public FileObjectContext context() {
        if (this.iterator == null) {
            throw new IllegalStateException("Iterator is not initialized for URI: " + String.valueOf(this.objectURI));
        }
        FileObjectContext context = this.iterator.context();
        return new FileObjectContext(this.key, context.metadata(), context.offset());
    }

    @Override
    public void seekTo(FileObjectOffset offset) {
        this.checkIsOpen();
        this.iterator.seekTo(offset);
    }

    @Override
    public RecordsIterable<FileRecord<TypedStruct>> next() {
        this.checkIsOpen();
        return this.iterator.next();
    }

    @Override
    public boolean hasNext() {
        this.checkIsOpen();
        return this.iterator.hasNext();
    }

    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            this.iterator.close();
            LOG.info("Closed iterator for: {} ", (Object)this.iterator.context().metadata());
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed.get();
    }

    private void checkIsOpen() {
        if (!this.isOpen()) {
            throw new IllegalStateException("This iterator is not initialized yet or already closed");
        }
    }
}

