/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.source;

import com.jsoniter.annotation.JsonCreator;
import com.jsoniter.annotation.JsonIgnore;
import com.jsoniter.annotation.JsonProperty;
import io.streamthoughts.kafka.connect.filepulse.source.FileObjectKey;
import io.streamthoughts.kafka.connect.filepulse.source.FileObjectMeta;
import io.streamthoughts.kafka.connect.filepulse.source.FileObjectOffset;
import io.streamthoughts.kafka.connect.filepulse.source.FileObjectStatus;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;

public final class FileObject
implements Serializable {
    @JsonIgnore
    private final transient FileObjectKey key;
    private final FileObjectMeta metadata;
    private final FileObjectOffset offset;
    private final FileObjectStatus status;

    @JsonCreator
    public FileObject(@JsonProperty(value="metadata") FileObjectMeta metadata, @JsonProperty(value="offset") FileObjectOffset offset, @JsonProperty(value="status") FileObjectStatus status) {
        this(metadata, offset, status, null);
    }

    public FileObject(FileObjectMeta metadata, FileObjectOffset offset, FileObjectStatus status, FileObjectKey key) {
        this.metadata = Objects.requireNonNull(metadata, "metadata can't be null");
        this.offset = Objects.requireNonNull(offset, "offset can't be null");
        this.status = Objects.requireNonNull(status, "status can't be null");
        this.key = key;
    }

    public FileObjectMeta metadata() {
        return this.metadata;
    }

    public FileObjectOffset offset() {
        return this.offset;
    }

    public FileObjectStatus status() {
        return this.status;
    }

    public Optional<FileObjectKey> key() {
        return Optional.ofNullable(this.key);
    }

    public FileObject withStatus(FileObjectStatus status) {
        return new FileObject(this.metadata, this.offset, status);
    }

    public FileObject withKey(FileObjectKey key) {
        return new FileObject(this.metadata, this.offset, this.status, key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileObject)) {
            return false;
        }
        FileObject that = (FileObject)o;
        return Objects.equals(this.metadata, that.metadata) && Objects.equals((Object)this.status, (Object)that.status) && Objects.equals(this.offset, that.offset);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.metadata, this.offset, this.status});
    }

    public String toString() {
        return "[source=" + String.valueOf(this.metadata) + ", offset=" + String.valueOf(this.offset) + ", status=" + String.valueOf((Object)this.status) + "]";
    }
}

