/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.source;

import com.jsoniter.annotation.JsonCreator;
import com.jsoniter.annotation.JsonProperty;
import io.streamthoughts.kafka.connect.filepulse.source.FileObjectMeta;
import java.net.URI;
import java.time.Instant;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class GenericFileObjectMeta
implements FileObjectMeta {
    private final URI uri;
    private final String name;
    private final Long contentLength;
    private final Long lastModified;
    private final FileObjectMeta.ContentDigest contentDigest;
    private final Map<String, Object> userDefinedMetadata;

    public GenericFileObjectMeta(URI uri) {
        this(Objects.requireNonNull(uri, "uri should not be null"), null, null, null, null, null);
    }

    @JsonCreator
    public GenericFileObjectMeta(@JsonProperty(value="uri") URI uri, @JsonProperty(value="name") String name, @JsonProperty(value="contentLength") Long contentLength, @JsonProperty(value="lastModified") Long lastModified, @JsonProperty(value="contentDigest") FileObjectMeta.ContentDigest contentDigest, @JsonProperty(value="userDefinedMetadata") Map<String, Object> userDefinedMetadata) {
        this.uri = uri;
        this.name = name;
        this.contentLength = contentLength;
        this.lastModified = lastModified;
        this.contentDigest = contentDigest;
        this.userDefinedMetadata = userDefinedMetadata == null ? new HashMap() : userDefinedMetadata;
    }

    public void addUserDefinedMetadata(String key, Object value) {
        this.userDefinedMetadata.put(key, value);
    }

    @Override
    public URI uri() {
        return this.uri;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Long contentLength() {
        return this.contentLength;
    }

    @Override
    public Long lastModified() {
        return this.lastModified;
    }

    @Override
    public FileObjectMeta.ContentDigest contentDigest() {
        return this.contentDigest;
    }

    @Override
    public Map<String, Object> userDefinedMetadata() {
        return this.userDefinedMetadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GenericFileObjectMeta)) {
            return false;
        }
        GenericFileObjectMeta that = (GenericFileObjectMeta)o;
        return Objects.equals(this.contentLength, that.contentLength) && Objects.equals(this.lastModified, that.lastModified) && Objects.equals(this.uri, that.uri) && Objects.equals(this.name, that.name) && Objects.equals(this.contentDigest, that.contentDigest);
    }

    public int hashCode() {
        return Objects.hash(this.uri, this.name, this.contentLength, this.lastModified, this.contentDigest);
    }

    public String toString() {
        return "[uri=" + String.valueOf(this.uri) + ", name='" + this.name + "', contentLength=" + this.contentLength + ", lastModified=" + this.lastModified + ", contentDigest=" + String.valueOf(this.contentDigest) + ", userDefinedMetadata=" + String.valueOf(this.userDefinedMetadata) + "]";
    }

    public static class Builder {
        private URI uri;
        private String name;
        private long contentLength;
        private long lastModified;
        private FileObjectMeta.ContentDigest contentDigest;
        private Map<String, Object> userDefinedMetadata;

        public Builder withUri(URI uri) {
            this.uri = uri;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withContentLength(long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        public Builder withLastModified(Date date) {
            return this.withLastModified(date.toInstant());
        }

        public Builder withLastModified(Instant instant) {
            return this.withLastModified(instant.toEpochMilli());
        }

        public Builder withLastModified(long lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public Builder withContentDigest(FileObjectMeta.ContentDigest contentDigest) {
            this.contentDigest = contentDigest;
            return this;
        }

        public Builder withUserDefinedMetadata(Map<String, Object> userDefinedMetadata) {
            this.userDefinedMetadata = userDefinedMetadata;
            return this;
        }

        public GenericFileObjectMeta build() {
            return new GenericFileObjectMeta(this.uri, this.name, this.contentLength, this.lastModified, this.contentDigest, this.userDefinedMetadata);
        }
    }
}

