/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.source;

import com.jsoniter.annotation.JsonIgnore;
import io.streamthoughts.kafka.connect.filepulse.errors.ConnectFilePulseException;
import io.streamthoughts.kafka.connect.filepulse.internal.IOUtils;
import io.streamthoughts.kafka.connect.filepulse.internal.Network;
import io.streamthoughts.kafka.connect.filepulse.source.FileObjectMeta;
import io.streamthoughts.kafka.connect.filepulse.source.GenericFileObjectMeta;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.zip.CRC32;

public class LocalFileObjectMeta
extends GenericFileObjectMeta {
    public static final String SYSTEM_FILE_INODE_META_KEY = "system.inode";
    public static final String SYSTEM_FILE_HOSTNAME_META_KEY = "system.hostname";
    @JsonIgnore
    private final File file;
    @JsonIgnore
    private final Long inode;

    public LocalFileObjectMeta(File file) {
        super(file.toURI(), file.getName(), file.length(), LocalFileObjectMeta.getLastModifiedTime(file), LocalFileObjectMeta.hash(file), new LinkedHashMap<String, Object>());
        this.file = file;
        Optional<Long> unixInode = IOUtils.getUnixInode(file);
        unixInode.ifPresent(it -> this.addUserDefinedMetadata(SYSTEM_FILE_INODE_META_KEY, it));
        this.inode = unixInode.orElse(null);
        this.addUserDefinedMetadata(SYSTEM_FILE_HOSTNAME_META_KEY, Network.HOSTNAME);
    }

    private static long getLastModifiedTime(File f) {
        try {
            return Files.getLastModifiedTime(f.toPath(), LinkOption.NOFOLLOW_LINKS).to(TimeUnit.MILLISECONDS);
        }
        catch (IOException e) {
            throw new ConnectFilePulseException("Error while getting last-modified time for file : " + f.getName() + " - " + e.getLocalizedMessage());
        }
    }

    @JsonIgnore
    public String path() {
        return this.file.getParentFile().getAbsolutePath();
    }

    @JsonIgnore
    public String absolutePath() {
        return this.file.getAbsolutePath();
    }

    @JsonIgnore
    public Long inode() {
        return this.inode;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    private static FileObjectMeta.ContentDigest hash(File f) {
        try {
            CRC32 crc32 = new CRC32();
            if (f.length() > 0L) {
                byte[] bytes = LocalFileObjectMeta.readStartingBytesFrom(f, 4096L);
                crc32.update(bytes);
                crc32.update(LocalFileObjectMeta.longToBytes(f.length()));
                return new FileObjectMeta.ContentDigest(String.valueOf(crc32.getValue()), "crc32");
            }
            return new FileObjectMeta.ContentDigest("", "crc32");
        }
        catch (IOException e) {
            throw new ConnectFilePulseException("Error while computing CRC32 hash for file : " + f.getName() + " - " + e.getLocalizedMessage());
        }
    }

    private static byte[] readStartingBytesFrom(File file, long n) throws IOException {
        int len = (int)Math.min(file.length(), n);
        byte[] buffer = new byte[len];
        try (FileInputStream is = new FileInputStream(file);){
            if (((InputStream)is).read(buffer) != -1) {
                byte[] byArray = buffer;
                return byArray;
            }
            throw new IOException("Reaching end of the stream while attempting to read first '" + len + "' bytes (file size=" + file.length() + ").");
        }
    }

    private static byte[] longToBytes(long x) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(x);
        return buffer.array();
    }
}

