/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.source;

import io.streamthoughts.kafka.connect.filepulse.data.TypedStruct;
import io.streamthoughts.kafka.connect.filepulse.data.TypedValue;
import io.streamthoughts.kafka.connect.filepulse.internal.StringUtils;
import io.streamthoughts.kafka.connect.filepulse.schema.SchemaMerger;
import io.streamthoughts.kafka.connect.filepulse.source.AbstractFileRecord;
import io.streamthoughts.kafka.connect.filepulse.source.FileObjectMeta;
import io.streamthoughts.kafka.connect.filepulse.source.FileRecord;
import io.streamthoughts.kafka.connect.filepulse.source.FileRecordOffset;
import io.streamthoughts.kafka.connect.filepulse.source.internal.ConnectSchemaMapper;
import io.streamthoughts.kafka.connect.filepulse.source.internal.InternalSourceRecordBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.header.ConnectHeaders;
import org.apache.kafka.connect.source.SourceRecord;

public class TypedFileRecord
extends AbstractFileRecord<TypedStruct> {
    public static final String DEFAULT_MESSAGE_FIELD = "message";
    private final InternalSourceRecordBuilder internalSourceRecordBuilder;
    private final ConnectSchemaMapper mapper = new ConnectSchemaMapper();

    public TypedFileRecord(FileRecordOffset offset, TypedStruct struct) {
        super(offset, struct);
        this.internalSourceRecordBuilder = new InternalSourceRecordBuilder();
    }

    @Override
    public SourceRecord toSourceRecord(Map<String, ?> sourcePartition, Map<String, ?> sourceOffset, FileObjectMeta metadata, String defaultTopic, Integer defaultPartition, Function<String, Schema> connectSchemaSupplier, FileRecord.ConnectSchemaMapperOptions options) {
        Schema valueSchema;
        Matcher matcher;
        this.mapper.setKeepLeadingUnderscoreCharacters(options.isKeepSchemaLeadingUnderscore());
        String recordTopic = this.internalSourceRecordBuilder.topic();
        String targetTopic = StringUtils.isNotBlank(recordTopic) ? recordTopic : defaultTopic;
        Schema connectSchema = Optional.ofNullable(connectSchemaSupplier.apply(targetTopic)).orElse(connectSchemaSupplier.apply(defaultTopic));
        Pattern topicPattern = options.getConnectSchemaConditionTopicPattern();
        if (topicPattern != null && !(matcher = topicPattern.matcher(targetTopic)).matches()) {
            connectSchema = null;
        }
        TypedStruct value = (TypedStruct)this.value();
        if (options.isConnectSchemaMergeEnabled() && value != null) {
            Schema recordValueSchema = value.schema().map(this.mapper, false);
            valueSchema = connectSchema != null ? SchemaMerger.merge(connectSchema, recordValueSchema) : recordValueSchema;
        } else {
            valueSchema = connectSchema;
        }
        if (valueSchema != null) {
            this.internalSourceRecordBuilder.withValue(() -> value == null ? null : this.mapper.map(valueSchema, value));
        } else {
            this.internalSourceRecordBuilder.withValue(() -> value == null ? null : this.mapper.map(value.schema(), value, false));
        }
        return this.internalSourceRecordBuilder.build(sourcePartition, sourceOffset, metadata, defaultTopic, defaultPartition);
    }

    public TypedFileRecord withTopic(String topic) {
        this.internalSourceRecordBuilder.withTopic(topic);
        return this;
    }

    public TypedFileRecord withPartition(Integer partition) {
        this.internalSourceRecordBuilder.withPartition(partition);
        return this;
    }

    public TypedFileRecord withTimestamp(Long timestamp) {
        this.internalSourceRecordBuilder.withTimestamp(timestamp);
        return this;
    }

    public TypedFileRecord withHeaders(ConnectHeaders headers) {
        this.internalSourceRecordBuilder.withHeaders(headers);
        return this;
    }

    public TypedFileRecord withKey(TypedValue key) {
        this.internalSourceRecordBuilder.withKey(() -> {
            if (key == null || key.isNull()) {
                return null;
            }
            return key.schema().map(this.mapper, key.value(), false);
        });
        return this;
    }
}

