/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.expression;

import io.streamthoughts.kafka.connect.filepulse.expression.EvaluationContext;
import io.streamthoughts.kafka.connect.filepulse.expression.accessor.HeadersAccessor;
import io.streamthoughts.kafka.connect.filepulse.expression.accessor.MapAdaptablePropertyAccessor;
import io.streamthoughts.kafka.connect.filepulse.expression.accessor.PropertyAccessor;
import io.streamthoughts.kafka.connect.filepulse.expression.accessor.ReflectivePropertyAccessor;
import io.streamthoughts.kafka.connect.filepulse.expression.accessor.StructFieldAccessor;
import io.streamthoughts.kafka.connect.filepulse.expression.accessor.TypedStructAccessor;
import io.streamthoughts.kafka.connect.filepulse.expression.converter.PrimitiveConverter;
import io.streamthoughts.kafka.connect.filepulse.expression.converter.PropertyConverter;
import io.streamthoughts.kafka.connect.filepulse.expression.converter.TypedValueConverter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class StandardEvaluationContext
implements EvaluationContext {
    private final Object rootObject;
    private final Map<String, Object> variables;
    private final List<PropertyAccessor> propertyAccessors;
    private final List<PropertyConverter> propertyConverters;

    public StandardEvaluationContext(Object rootObject) {
        this(rootObject, new HashMap<String, Object>(), new LinkedList<PropertyAccessor>(), new LinkedList<PropertyConverter>());
    }

    public StandardEvaluationContext(Object rootObject, Map<String, Object> variables) {
        this(rootObject, variables, new LinkedList<PropertyAccessor>(), new LinkedList<PropertyConverter>());
    }

    private StandardEvaluationContext(Object rootObject, Map<String, Object> variables, List<PropertyAccessor> propertyAccessors, List<PropertyConverter> converters) {
        Objects.requireNonNull(rootObject, "rootObject cannot be null");
        Objects.requireNonNull(variables, "variables cannot be null");
        Objects.requireNonNull(propertyAccessors, "propertyAccessors cannot be null");
        this.rootObject = rootObject;
        this.variables = variables;
        this.propertyAccessors = propertyAccessors;
        this.propertyAccessors.add(new HeadersAccessor());
        this.propertyAccessors.add(new TypedStructAccessor());
        this.propertyAccessors.add(new StructFieldAccessor());
        this.propertyAccessors.add(new MapAdaptablePropertyAccessor());
        this.propertyAccessors.add(new ReflectivePropertyAccessor());
        this.propertyConverters = converters;
        this.propertyConverters.add(new PrimitiveConverter());
        this.propertyConverters.add(new TypedValueConverter());
    }

    @Override
    public Object rootObject() {
        return this.rootObject;
    }

    @Override
    public List<PropertyAccessor> getPropertyAccessors() {
        return this.propertyAccessors;
    }

    @Override
    public List<PropertyConverter> getPropertyConverter() {
        return this.propertyConverters;
    }

    @Override
    public boolean has(String name) {
        return this.variables.containsKey(name);
    }

    @Override
    public Object get(String name) {
        return this.variables.get(name);
    }

    @Override
    public void set(String name, Object value) {
        this.variables.put(name, value);
    }

    @Override
    public Set<String> variables() {
        return this.variables.keySet();
    }

    @Override
    public Map<String, Object> values() {
        return this.variables;
    }
}

