/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.expression;

import io.streamthoughts.kafka.connect.filepulse.data.TypedValue;
import io.streamthoughts.kafka.connect.filepulse.expression.AbstractExpression;
import io.streamthoughts.kafka.connect.filepulse.expression.EvaluationContext;
import io.streamthoughts.kafka.connect.filepulse.expression.Expression;
import io.streamthoughts.kafka.connect.filepulse.expression.converter.Converters;
import io.streamthoughts.kafka.connect.filepulse.expression.converter.PropertyConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class SubstitutionExpression
extends AbstractExpression {
    private final TreeSet<ReplacementExpression> replacements = new TreeSet();

    public SubstitutionExpression(String original) {
        super(original);
    }

    public SubstitutionExpression(String original, int startIndex, int endIndex, Expression replacement) {
        super(original);
        this.addReplacement(startIndex, endIndex, replacement);
    }

    public void addReplacement(int startIndex, int endIndex, Expression replacement) {
        this.addReplacement(new ReplacementExpression("", startIndex, endIndex, Collections.singletonList(replacement)));
    }

    public void addReplacement(ReplacementExpression expression) {
        if (expression.startIndex < 0) {
            throw new IllegalArgumentException("startIndex must be superior to 0");
        }
        if (expression.endIndex > this.originalExpression().length()) {
            throw new IllegalArgumentException("endIndex must be inferior to the original expression length (" + this.originalExpression().length() + "): " + expression.endIndex);
        }
        this.replacements.add(expression);
    }

    @Override
    public Object readValue(EvaluationContext context) {
        return Optional.ofNullable(this.readValue(context, TypedValue.class)).map(TypedValue::value).orElse(null);
    }

    @Override
    public <T> T readValue(EvaluationContext context, Class<T> expectedType) {
        ReplacementExpression expression;
        Objects.requireNonNull(context, "context cannot be null");
        if (this.isSingleSubstitution() && (expression = this.replacements.iterator().next()).endIndex() - expression.startIndex() == this.originalExpression().length()) {
            return expression.readValue(context, expectedType);
        }
        StringBuilder sb = new StringBuilder();
        int offset = 0;
        for (ReplacementExpression replacement : this.replacements) {
            String replacementString = replacement.readValue(context, String.class);
            if (offset < replacement.startIndex()) {
                sb.append(this.originalExpression(), offset, replacement.startIndex());
            }
            sb.append(replacementString);
            offset = replacement.endIndex();
        }
        if (offset != this.originalExpression().length()) {
            sb.append(this.originalExpression(), offset, this.originalExpression().length());
        }
        String value = sb.toString();
        List<PropertyConverter> converters = context.getPropertyConverter();
        return Converters.converts(converters, value, expectedType);
    }

    @Override
    public void writeValue(Object value, EvaluationContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    private boolean isSingleSubstitution() {
        return this.replacements.size() == 1;
    }

    public TreeSet<ReplacementExpression> getReplacements() {
        return this.replacements;
    }

    public String toString() {
        return "[originalExpression=" + this.originalExpression() + ", replacements=" + String.valueOf(this.replacements) + "]";
    }

    public static final class ReplacementExpression
    extends AbstractExpression
    implements Comparable<ReplacementExpression> {
        private final int startIndex;
        private final int endIndex;
        private final List<Expression> expressions;

        public ReplacementExpression(String originalExpression, int startIndex, int endIndex, List<Expression> expressions) {
            super(originalExpression);
            this.expressions = Objects.requireNonNull(expressions, "expressions cannot be null");
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }

        public int startIndex() {
            return this.startIndex;
        }

        public int endIndex() {
            return this.endIndex;
        }

        public List<Expression> expressions() {
            return this.expressions;
        }

        @Override
        public Object readValue(EvaluationContext context) {
            ArrayList<TypedValue> values = new ArrayList<TypedValue>(this.expressions.size());
            for (Expression replacement : this.expressions) {
                values.add(replacement.readValue(context, TypedValue.class));
            }
            if (values.size() == 1) {
                TypedValue typed = (TypedValue)values.get(0);
                return typed == null ? null : typed.value();
            }
            return values.stream().map(TypedValue::getString).collect(Collectors.joining());
        }

        @Override
        public <T> T readValue(EvaluationContext context, Class<T> expectedType) {
            Object returned = this.readValue(context);
            if (returned == null) {
                return null;
            }
            if (expectedType.isAssignableFrom(returned.getClass())) {
                return (T)returned;
            }
            List<PropertyConverter> converters = context.getPropertyConverter();
            return Converters.converts(converters, returned, expectedType);
        }

        @Override
        public void writeValue(Object value, EvaluationContext context) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean canWrite() {
            return false;
        }

        @Override
        public int compareTo(ReplacementExpression that) {
            Objects.requireNonNull(that, "cannot compare to null object");
            return Integer.compare(this.startIndex, that.startIndex);
        }

        public String toString() {
            return "[startIndex=" + this.startIndex + ", endIndex=" + this.endIndex + ", expressions=" + String.valueOf(this.expressions) + "]";
        }
    }
}

