/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.expression.accessor;

import io.streamthoughts.kafka.connect.filepulse.expression.EvaluationContext;
import io.streamthoughts.kafka.connect.filepulse.expression.accessor.AccessException;
import io.streamthoughts.kafka.connect.filepulse.expression.accessor.PropertyAccessor;
import io.streamthoughts.kafka.connect.filepulse.expression.accessor.PropertyAccessors;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class MapAdaptablePropertyAccessor
implements PropertyAccessor {
    private static final String GET_METHOD_NAME = "get";
    private static final String PUT_METHOD_NAME = "put";
    private static final String DOT = ".";

    @Override
    public Class<?>[] getSpecificTargetClasses() {
        return new Class[]{Map.class};
    }

    @Override
    public boolean canRead(EvaluationContext context, Object target, String name) throws AccessException {
        return true;
    }

    @Override
    public Object read(EvaluationContext context, Object target, String name) throws AccessException {
        Objects.requireNonNull(target, "target cannot be null");
        Objects.requireNonNull(name, "name cannot be null");
        Class<?> type = target instanceof Class ? (Class<?>)target : target.getClass();
        return Map.class.isAssignableFrom(type) ? this.readFromMapObject(context, (Map)target, name) : this.readFromMapAdaptableObject(context, target, name, type);
    }

    private Object readFromMapAdaptableObject(EvaluationContext context, Object target, String key, Class<?> type) {
        try {
            Method method = this.findGetterByKeyMethodForProperty(type);
            if (method != null && method.canAccess(target)) {
                String[] split;
                Object rootObject;
                Object result = method.invoke(target, key);
                if (result != null) {
                    return result;
                }
                if (MapAdaptablePropertyAccessor.isDotPropertyAccessPath(key) && (rootObject = method.invoke(target, (split = key.split("\\.", 2))[0])) != null) {
                    return new PropertyAccessors(context).readPropertyValue(rootObject, split[1]);
                }
            }
            throw new AccessException("Cannot access map property with key '" + key + "'. Entry does not exist.");
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new AccessException(e.getMessage());
        }
    }

    private Object readFromMapObject(EvaluationContext context, Map<String, Object> target, String key) {
        Object rootObject;
        String[] split;
        String rootKey;
        if (target.containsKey(key)) {
            return target.get(key);
        }
        if (MapAdaptablePropertyAccessor.isDotPropertyAccessPath(key) && target.containsKey(rootKey = (split = key.split("\\.", 2))[0]) && (rootObject = target.get(rootKey)) != null) {
            return new PropertyAccessors(context).readPropertyValue(rootObject, split[1]);
        }
        throw new AccessException("Cannot access map property with key '" + key + "'. Entry does not exist.");
    }

    @Override
    public void write(EvaluationContext context, Object target, String name, Object newValue) throws AccessException {
        Objects.requireNonNull(target, "target cannot be null");
        Objects.requireNonNull(name, "name cannot be null");
        Class<?> type = target instanceof Class ? (Class<?>)target : target.getClass();
        Method method = this.findSetterByKeyMethodForProperty(type, name);
        if (method == null) {
            throw new AccessException(String.format("Cannot found access method for attribute %s on class %s", name, target.getClass().getCanonicalName()));
        }
        try {
            method.invoke(target, name, newValue);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new AccessException(e.getMessage());
        }
    }

    @Override
    public boolean canWrite(EvaluationContext context, Object target, String name) throws AccessException {
        return true;
    }

    private Method findGetterByKeyMethodForProperty(Class<?> target) {
        return this.findMethodForProperty(target, this::isAccessibleByKey);
    }

    private Method findMethodForProperty(Class<?> target, Predicate<Method> predicate) {
        Optional<Method> optional = Arrays.stream(target.getMethods()).filter(predicate).findAny();
        return optional.orElse(null);
    }

    private Method findSetterByKeyMethodForProperty(Class<?> target, Object newValue) {
        return this.findMethodForProperty(target, method -> this.isSettableByKeyAssignableFrom((Method)method, newValue));
    }

    private boolean isAccessibleByKey(Method m) {
        String methodName = m.getName();
        if (methodName.equals(GET_METHOD_NAME) && m.getParameterCount() == 1) {
            Class<?>[] parameterTypes = m.getParameterTypes();
            return parameterTypes[0].isAssignableFrom(String.class);
        }
        return false;
    }

    private boolean isSettableByKeyAssignableFrom(Method m, Object newValue) {
        String methodName = m.getName();
        if (methodName.equals(PUT_METHOD_NAME) && m.getParameterCount() == 2) {
            Class<?>[] parameterTypes = m.getParameterTypes();
            boolean isStringKey = parameterTypes[0].isAssignableFrom(String.class);
            boolean isObjectValue = parameterTypes[1].isAssignableFrom(newValue.getClass());
            return isStringKey && isObjectValue;
        }
        return false;
    }

    private static boolean isDotPropertyAccessPath(String name) {
        return name.contains(DOT);
    }
}

