/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.expression.accessor;

import io.streamthoughts.kafka.connect.filepulse.expression.EvaluationContext;
import io.streamthoughts.kafka.connect.filepulse.expression.accessor.AccessException;
import io.streamthoughts.kafka.connect.filepulse.expression.accessor.PropertyAccessor;
import io.streamthoughts.kafka.connect.filepulse.expression.accessor.PropertyAccessors;
import io.streamthoughts.kafka.connect.filepulse.expression.converter.Converters;
import java.lang.reflect.Method;
import java.util.Objects;

public class ReflectivePropertyAccessor
implements PropertyAccessor {
    private static final String GETTER_PREFIX = "get";
    private static final String SETTER_PREFIX = "set";
    private static final String DOT = ".";

    @Override
    public boolean canRead(EvaluationContext context, Object target, String name) throws AccessException {
        return true;
    }

    @Override
    public Object read(EvaluationContext context, Object target, String name) throws AccessException {
        Objects.requireNonNull(target, "target cannot be null");
        Objects.requireNonNull(name, "name cannot be null");
        Class<?> type = target instanceof Class ? (Class<?>)target : target.getClass();
        try {
            String[] split;
            Method rootMethod;
            Method method = this.findGetterMethodForProperty(type, name);
            if (method != null || (method = this.findAccessMethodForProperty(type, name)) != null) {
                method.setAccessible(true);
                return method.invoke(target, new Object[0]);
            }
            if (ReflectivePropertyAccessor.isDotPropertyAccessPath(name) && ((rootMethod = this.findGetterMethodForProperty(type, (split = name.split("\\.", 2))[0])) != null || (rootMethod = this.findAccessMethodForProperty(type, name)) != null)) {
                rootMethod.setAccessible(true);
                Object rootObject = rootMethod.invoke(target, new Object[0]);
                return new PropertyAccessors(context).readPropertyValue(rootObject, split[1]);
            }
        }
        catch (Exception e) {
            throw new AccessException(e.getMessage());
        }
        throw new AccessException(String.format("Cannot found getter method for attribute '%s' on class '%s'", name, target.getClass()));
    }

    @Override
    public void write(EvaluationContext context, Object target, String name, Object newValue) throws AccessException {
        Objects.requireNonNull(target, "target cannot be null");
        Objects.requireNonNull(name, "name cannot be null");
        Class<?> type = target instanceof Class ? (Class<?>)target : target.getClass();
        try {
            Method method = this.findSetterMethodForProperty(type, name);
            if (method != null) {
                method.setAccessible(true);
                Class<?> expectedSetterType = method.getParameterTypes()[0];
                Object converted = Converters.converts(context.getPropertyConverter(), newValue, expectedSetterType);
                method.invoke(target, converted);
                return;
            }
        }
        catch (Exception e) {
            throw new AccessException(String.format("Cannot set property '%s' to '%s' on target type %s : %s", name, target.getClass().getSimpleName(), target.getClass().getSimpleName(), e.getMessage()));
        }
        throw new AccessException(String.format("Cannot found setter method for attribute '%s' on class '%s'", name, target.getClass().getCanonicalName()));
    }

    @Override
    public boolean canWrite(EvaluationContext context, Object target, String name) throws AccessException {
        return true;
    }

    private Method findGetterMethodForProperty(Class<?> target, String name) {
        for (Method m : target.getMethods()) {
            String methodName = m.getName();
            if (!methodName.equals(GETTER_PREFIX + this.getMethodSuffixForProperty(name))) continue;
            return m;
        }
        return null;
    }

    private Method findSetterMethodForProperty(Class<?> target, String name) {
        for (Method m : target.getDeclaredMethods()) {
            String methodName = m.getName();
            if (!methodName.equals(SETTER_PREFIX + this.getMethodSuffixForProperty(name))) continue;
            return m;
        }
        return null;
    }

    private Method findAccessMethodForProperty(Class<?> target, String name) {
        for (Method m : target.getMethods()) {
            String methodName = m.getName();
            if (!methodName.equals(name)) continue;
            return m;
        }
        return null;
    }

    private String getMethodSuffixForProperty(String name) {
        return Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    private static boolean isDotPropertyAccessPath(String name) {
        return name.contains(DOT);
    }
}

