/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.expression.accessor;

import io.streamthoughts.kafka.connect.filepulse.expression.EvaluationContext;
import io.streamthoughts.kafka.connect.filepulse.expression.accessor.AccessException;
import io.streamthoughts.kafka.connect.filepulse.expression.accessor.PropertyAccessor;
import java.util.Objects;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.Struct;

public class StructFieldAccessor
implements PropertyAccessor {
    @Override
    public Class<?>[] getSpecificTargetClasses() {
        return new Class[]{Struct.class, SchemaAndValue.class};
    }

    @Override
    public boolean canRead(EvaluationContext context, Object target, String name) throws AccessException {
        return Schema.Type.STRUCT.equals((Object)((SchemaAndValue)target).schema().type());
    }

    public SchemaAndValue read(EvaluationContext context, Object target, String name) throws AccessException {
        String[] split;
        SchemaAndValue rootObject;
        Objects.requireNonNull(target, "target cannot be null");
        Objects.requireNonNull(name, "name cannot be null");
        Struct struct = this.getStructValue(target);
        Field field = struct.schema().field(name);
        if (field != null) {
            return new SchemaAndValue(field.schema(), struct.get(field));
        }
        if (this.isDotPropertyAccessPath(name) && (rootObject = this.read(context, target, (split = name.split("\\.", 2))[0])) != null) {
            return this.read(context, rootObject, split[1]);
        }
        throw new AccessException("Can't access field '" + name + "' from Struct - field does not exist");
    }

    @Override
    public void write(EvaluationContext context, Object target, String name, Object newValue) throws AccessException {
        throw new UnsupportedOperationException("Cannot write to new field into Struct/SchemaAndValue object");
    }

    private Struct getStructValue(Object target) {
        if (target instanceof SchemaAndValue) {
            return (Struct)((SchemaAndValue)target).value();
        }
        return (Struct)target;
    }

    @Override
    public boolean canWrite(EvaluationContext context, Object target, String name) throws AccessException {
        return false;
    }

    private boolean isDotPropertyAccessPath(String name) {
        return name.contains(".");
    }
}

