/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.expression.function;

import io.streamthoughts.kafka.connect.filepulse.expression.Expression;
import io.streamthoughts.kafka.connect.filepulse.expression.ExpressionException;
import io.streamthoughts.kafka.connect.filepulse.expression.function.Arguments;
import io.streamthoughts.kafka.connect.filepulse.expression.function.ExpressionFunction;
import io.streamthoughts.kafka.connect.filepulse.expression.function.ExpressionFunctionExecutor;
import io.streamthoughts.kafka.connect.filepulse.expression.function.collections.ExtractArray;
import io.streamthoughts.kafka.connect.filepulse.expression.function.conditions.And;
import io.streamthoughts.kafka.connect.filepulse.expression.function.conditions.Equals;
import io.streamthoughts.kafka.connect.filepulse.expression.function.conditions.GreaterThan;
import io.streamthoughts.kafka.connect.filepulse.expression.function.conditions.If;
import io.streamthoughts.kafka.connect.filepulse.expression.function.conditions.LessThan;
import io.streamthoughts.kafka.connect.filepulse.expression.function.conditions.Not;
import io.streamthoughts.kafka.connect.filepulse.expression.function.conditions.Or;
import io.streamthoughts.kafka.connect.filepulse.expression.function.datetime.TimestampDiff;
import io.streamthoughts.kafka.connect.filepulse.expression.function.datetime.ToTimestamp;
import io.streamthoughts.kafka.connect.filepulse.expression.function.datetime.UnixTimestamp;
import io.streamthoughts.kafka.connect.filepulse.expression.function.objects.Converts;
import io.streamthoughts.kafka.connect.filepulse.expression.function.objects.Exists;
import io.streamthoughts.kafka.connect.filepulse.expression.function.objects.ExtractStructField;
import io.streamthoughts.kafka.connect.filepulse.expression.function.objects.IsNull;
import io.streamthoughts.kafka.connect.filepulse.expression.function.objects.Nlv;
import io.streamthoughts.kafka.connect.filepulse.expression.function.strings.Concat;
import io.streamthoughts.kafka.connect.filepulse.expression.function.strings.ConcatWs;
import io.streamthoughts.kafka.connect.filepulse.expression.function.strings.EndsWith;
import io.streamthoughts.kafka.connect.filepulse.expression.function.strings.FromBytes;
import io.streamthoughts.kafka.connect.filepulse.expression.function.strings.Hash;
import io.streamthoughts.kafka.connect.filepulse.expression.function.strings.IsEmpty;
import io.streamthoughts.kafka.connect.filepulse.expression.function.strings.Length;
import io.streamthoughts.kafka.connect.filepulse.expression.function.strings.Lowercase;
import io.streamthoughts.kafka.connect.filepulse.expression.function.strings.Matches;
import io.streamthoughts.kafka.connect.filepulse.expression.function.strings.Md5;
import io.streamthoughts.kafka.connect.filepulse.expression.function.strings.ParseUrl;
import io.streamthoughts.kafka.connect.filepulse.expression.function.strings.ReplaceAll;
import io.streamthoughts.kafka.connect.filepulse.expression.function.strings.Split;
import io.streamthoughts.kafka.connect.filepulse.expression.function.strings.StartsWith;
import io.streamthoughts.kafka.connect.filepulse.expression.function.strings.Trim;
import io.streamthoughts.kafka.connect.filepulse.expression.function.strings.Uppercase;
import io.streamthoughts.kafka.connect.filepulse.expression.function.strings.Uuid;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionFunctionExecutors {
    private static final Logger LOG = LoggerFactory.getLogger(ExpressionFunctionExecutors.class);
    public static final ExpressionFunctionExecutors INSTANCE = new ExpressionFunctionExecutors();
    private final Map<String, ExpressionFunction> functions = new HashMap<String, ExpressionFunction>();

    public static ExpressionFunctionExecutor resolve(String functionName, Expression[] arguments) {
        return INSTANCE.make(functionName, arguments);
    }

    private ExpressionFunctionExecutors() {
        this.register(new Lowercase());
        this.register(new Uppercase());
        this.register(new Converts());
        this.register(new Length());
        this.register(new Nlv());
        this.register(new ExtractArray());
        this.register(new StartsWith());
        this.register(new EndsWith());
        this.register(new IsNull());
        this.register(new Matches());
        this.register(new Exists());
        this.register(new Equals());
        this.register(new Trim());
        this.register(new IsEmpty());
        this.register(new ReplaceAll());
        this.register(new Uuid());
        this.register(new Concat());
        this.register(new ConcatWs());
        this.register(new Hash());
        this.register(new Md5());
        this.register(new Split());
        this.register(new UnixTimestamp());
        this.register(new ToTimestamp());
        this.register(new TimestampDiff());
        this.register(new If());
        this.register(new And());
        this.register(new Or());
        this.register(new GreaterThan());
        this.register(new LessThan());
        this.register(new Not());
        this.register(new ParseUrl());
        this.register(new ExtractStructField());
        this.register(new FromBytes());
    }

    private ExpressionFunctionExecutor make(String functionName, Expression[] arguments) {
        Arguments prepared;
        Objects.requireNonNull(functionName, "functionName cannot be null");
        boolean exists = this.functions.containsKey(functionName);
        if (!exists) {
            throw new ExpressionException("Invalid expression, function does not exist '" + functionName + "'. Valid functions are : " + String.valueOf(this.functions.keySet()));
        }
        ExpressionFunction function = this.functions.get(functionName);
        ExpressionFunction.Instance instance = function.get();
        try {
            prepared = instance.prepare(arguments);
        }
        catch (Exception e) {
            throw new ExpressionException("Failed to prepare function '" + functionName + "': " + e.getMessage());
        }
        return new ExpressionFunctionExecutor(functionName, instance, prepared);
    }

    public void register(ExpressionFunction function) {
        Objects.requireNonNull(function, "'function' should not be null");
        LOG.info("Registered built-in expression function '{}'", (Object)function.name());
        this.functions.put(function.name(), function);
    }
}

