/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.expression.function.collections;

import io.streamthoughts.kafka.connect.filepulse.data.DataException;
import io.streamthoughts.kafka.connect.filepulse.data.Type;
import io.streamthoughts.kafka.connect.filepulse.data.TypedValue;
import io.streamthoughts.kafka.connect.filepulse.expression.Expression;
import io.streamthoughts.kafka.connect.filepulse.expression.ExpressionException;
import io.streamthoughts.kafka.connect.filepulse.expression.ValueExpression;
import io.streamthoughts.kafka.connect.filepulse.expression.function.AbstractExpressionFunctionInstance;
import io.streamthoughts.kafka.connect.filepulse.expression.function.Arguments;
import io.streamthoughts.kafka.connect.filepulse.expression.function.EvaluatedExecutionContext;
import io.streamthoughts.kafka.connect.filepulse.expression.function.ExpressionFunction;
import java.util.ArrayList;
import java.util.Objects;

public class ExtractArray
implements ExpressionFunction {
    private static final String ARRAY_ARG = "array";
    private static final String INDEX_ARG = "index";

    @Override
    public ExpressionFunction.Instance get() {
        return new ExtractArrayInstance(this.name());
    }

    static class ExtractArrayInstance
    extends AbstractExpressionFunctionInstance {
        private int index;
        private final String name;

        ExtractArrayInstance(String name) {
            this.name = Objects.requireNonNull(name, "'name' should not be null");
        }

        private String syntax() {
            return String.format("syntax %s(<%s>, <%s>)", this.name, ExtractArray.ARRAY_ARG, ExtractArray.INDEX_ARG);
        }

        @Override
        public Arguments prepare(Expression[] args) {
            if (args.length < 2) {
                throw new ExpressionException("Missing arguments: " + this.syntax());
            }
            try {
                this.index = ((ValueExpression)args[1]).value().getInt();
                return Arguments.of(ExtractArray.ARRAY_ARG, args[0], ExtractArray.INDEX_ARG, args[1]);
            }
            catch (DataException e) {
                throw new ExpressionException("Invalid argument: 'index' must be of type 'integer'");
            }
        }

        @Override
        public TypedValue invoke(EvaluatedExecutionContext context) throws ExpressionException {
            TypedValue value = context.get(0);
            if (value.type() != Type.ARRAY) {
                throw new ExpressionException("Expected type ARRAY, was " + String.valueOf(value.type()));
            }
            ArrayList list = new ArrayList(value.getArray());
            return TypedValue.any(list.get(this.index));
        }
    }
}

