/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.expression.function.conditions;

import io.streamthoughts.kafka.connect.filepulse.data.Type;
import io.streamthoughts.kafka.connect.filepulse.data.TypedValue;
import io.streamthoughts.kafka.connect.filepulse.expression.Expression;
import io.streamthoughts.kafka.connect.filepulse.expression.ExpressionException;
import io.streamthoughts.kafka.connect.filepulse.expression.function.AbstractExpressionFunctionInstance;
import io.streamthoughts.kafka.connect.filepulse.expression.function.Arguments;
import io.streamthoughts.kafka.connect.filepulse.expression.function.EvaluatedExecutionContext;
import io.streamthoughts.kafka.connect.filepulse.expression.function.ExpressionFunction;

public class Equals
implements ExpressionFunction {
    private static final String OBJECT_L_ARG = "object_expr1";
    private static final String OBJECT_R_ARG = "object_expr2";

    @Override
    public ExpressionFunction.Instance get() {
        return new AbstractExpressionFunctionInstance(){

            private String syntax() {
                return String.format("syntax %s(<%s>, <%s>)", Equals.this.name(), Equals.OBJECT_L_ARG, Equals.OBJECT_R_ARG);
            }

            @Override
            public Arguments prepare(Expression[] args) {
                if (args.length < 2) {
                    throw new ExpressionException("Missing required arguments: " + this.syntax());
                }
                return Arguments.of(Equals.OBJECT_L_ARG, args[0], Equals.OBJECT_R_ARG, args[1]);
            }

            @Override
            public TypedValue invoke(EvaluatedExecutionContext context) throws ExpressionException {
                TypedValue left = context.get(Equals.OBJECT_L_ARG);
                TypedValue right = context.get(Equals.OBJECT_R_ARG);
                if (left.isNull() && right.isNull()) {
                    return TypedValue.bool((Boolean)true);
                }
                if (left.isNull() || right.isNull()) {
                    return TypedValue.bool((Boolean)false);
                }
                Object leftValue = left.value();
                Object rightValue = right.as(left.type()).value();
                return TypedValue.of((Object)leftValue.equals(rightValue), (Type)Type.BOOLEAN);
            }
        };
    }
}

