/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.expression.function.objects;

import io.streamthoughts.kafka.connect.filepulse.data.Type;
import io.streamthoughts.kafka.connect.filepulse.data.TypedStruct;
import io.streamthoughts.kafka.connect.filepulse.data.TypedValue;
import io.streamthoughts.kafka.connect.filepulse.expression.Expression;
import io.streamthoughts.kafka.connect.filepulse.expression.ExpressionException;
import io.streamthoughts.kafka.connect.filepulse.expression.function.AbstractExpressionFunctionInstance;
import io.streamthoughts.kafka.connect.filepulse.expression.function.Arguments;
import io.streamthoughts.kafka.connect.filepulse.expression.function.EvaluatedExecutionContext;
import io.streamthoughts.kafka.connect.filepulse.expression.function.ExpressionFunction;

public class Exists
implements ExpressionFunction {
    private static final String OBJECT_ARG = "object_expr";
    private static final String FIELD_ARG = "field_expr";

    @Override
    public ExpressionFunction.Instance get() {
        return new AbstractExpressionFunctionInstance(){

            private String syntax() {
                return String.format("syntax %s(<%s>, <%s>)", Exists.this.name(), Exists.OBJECT_ARG, Exists.FIELD_ARG);
            }

            @Override
            public Arguments prepare(Expression[] args) {
                if (args.length < 2) {
                    throw new ExpressionException("Missing required arguments: " + this.syntax());
                }
                return Arguments.of(Exists.OBJECT_ARG, args[0], Exists.FIELD_ARG, args[1]);
            }

            @Override
            public TypedValue invoke(EvaluatedExecutionContext context) throws ExpressionException {
                TypedValue object = context.get(Exists.OBJECT_ARG);
                TypedValue path = context.get(Exists.FIELD_ARG);
                if (object.type() != Type.STRUCT && object.type() != Type.NULL) {
                    throw new ExpressionException("Expected type [STRUCT|NULL], was " + String.valueOf(object.type()));
                }
                if (object.type() == Type.NULL) {
                    return TypedValue.bool((Boolean)false);
                }
                TypedStruct struct = object.getStruct();
                boolean exists = struct.exists(path.getString());
                return TypedValue.bool((Boolean)exists);
            }
        };
    }
}

