/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.expression.function.strings;

import io.streamthoughts.kafka.connect.filepulse.data.TypedValue;
import io.streamthoughts.kafka.connect.filepulse.expression.Expression;
import io.streamthoughts.kafka.connect.filepulse.expression.ExpressionException;
import io.streamthoughts.kafka.connect.filepulse.expression.function.AbstractExpressionFunctionInstance;
import io.streamthoughts.kafka.connect.filepulse.expression.function.Argument;
import io.streamthoughts.kafka.connect.filepulse.expression.function.Arguments;
import io.streamthoughts.kafka.connect.filepulse.expression.function.EvaluatedExecutionContext;
import io.streamthoughts.kafka.connect.filepulse.expression.function.ExpressionArgument;
import io.streamthoughts.kafka.connect.filepulse.expression.function.ExpressionFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ConcatWs
implements ExpressionFunction {
    private static final String SEPARATOR_ARG = "separator";
    private static final String PREFIX_ARG = "prefix";
    private static final String SUFFIX_ARG = "suffix";

    @Override
    public ExpressionFunction.Instance get() {
        return new AbstractExpressionFunctionInstance(){

            private String syntax() {
                return String.format("syntax %s(<%s>, <%s>, <%s> [, <expressions])", ConcatWs.this.name(), ConcatWs.SEPARATOR_ARG, ConcatWs.PREFIX_ARG, ConcatWs.SUFFIX_ARG);
            }

            @Override
            public Arguments prepare(Expression[] args) {
                if (args.length < 3) {
                    throw new ExpressionException("Missing required arguments: " + this.syntax());
                }
                ArrayList<Argument> arguments = new ArrayList<Argument>(args.length);
                arguments.add(new ExpressionArgument(ConcatWs.SEPARATOR_ARG, args[0]));
                arguments.add(new ExpressionArgument(ConcatWs.PREFIX_ARG, args[1]));
                arguments.add(new ExpressionArgument(ConcatWs.SUFFIX_ARG, args[2]));
                for (int i = 3; i < args.length; ++i) {
                    arguments.add(new ExpressionArgument("expr" + (i - 2), args[i]));
                }
                return new Arguments(arguments);
            }

            @Override
            public TypedValue invoke(EvaluatedExecutionContext context) throws ExpressionException {
                return this.apply(context.get(0).getString(), context.get(1).getString(), context.get(2).getString(), context.get(3, context.size()));
            }

            public TypedValue apply(String delimiter, String prefix, String suffix, List<TypedValue> values) {
                String concat = values.stream().filter(TypedValue::isNotNull).map(TypedValue::getString).collect(Collectors.joining(delimiter, prefix, suffix));
                return TypedValue.string((String)concat);
            }
        };
    }
}

