/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.expression.function.strings;

import io.streamthoughts.kafka.connect.filepulse.data.Type;
import io.streamthoughts.kafka.connect.filepulse.data.TypedValue;
import io.streamthoughts.kafka.connect.filepulse.expression.Expression;
import io.streamthoughts.kafka.connect.filepulse.expression.ExpressionException;
import io.streamthoughts.kafka.connect.filepulse.expression.ValueExpression;
import io.streamthoughts.kafka.connect.filepulse.expression.function.AbstractExpressionFunctionInstance;
import io.streamthoughts.kafka.connect.filepulse.expression.function.Arguments;
import io.streamthoughts.kafka.connect.filepulse.expression.function.EvaluatedExecutionContext;
import io.streamthoughts.kafka.connect.filepulse.expression.function.ExpressionFunction;
import io.streamthoughts.kafka.connect.filepulse.internal.Encoding;
import java.util.Objects;

public class FromBytes
implements ExpressionFunction {
    @Override
    public ExpressionFunction.Instance get() {
        return new FunctionInstance(this.syntax());
    }

    private String syntax() {
        return String.format("syntax %s(<byte_expression>, <encoding>", this.name());
    }

    private static final class FunctionInstance
    extends AbstractExpressionFunctionInstance {
        private static final int EXPECTED_NUM_ARGS = 2;
        private final String syntax;
        private Encoding encoding;

        public FunctionInstance(String syntax) {
            this.syntax = Objects.requireNonNull(syntax, "'syntax' should not be null");
        }

        @Override
        public Arguments prepare(Expression[] args) throws ExpressionException {
            if (args.length > 2) {
                throw new ExpressionException("Too many arguments: " + this.syntax);
            }
            if (args.length < 2) {
                throw new ExpressionException("Missing required arguments: " + this.syntax);
            }
            this.encoding = Encoding.from((String)((ValueExpression)args[1]).value().getString());
            return Arguments.of("bytes", args[0]);
        }

        @Override
        public TypedValue invoke(EvaluatedExecutionContext context) throws ExpressionException {
            TypedValue value = context.get(0);
            if (value.isNull()) {
                return TypedValue.none();
            }
            if (value.type() != Type.BYTES) {
                throw new ExpressionException("Expected type BYTES, was " + String.valueOf(value.type()));
            }
            return TypedValue.string((String)this.encoding.encode(value.getBytes()));
        }
    }
}

