/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.expression.function.strings;

import io.streamthoughts.kafka.connect.filepulse.data.TypedValue;
import io.streamthoughts.kafka.connect.filepulse.expression.Expression;
import io.streamthoughts.kafka.connect.filepulse.expression.ExpressionException;
import io.streamthoughts.kafka.connect.filepulse.expression.ValueExpression;
import io.streamthoughts.kafka.connect.filepulse.expression.function.AbstractExpressionFunctionInstance;
import io.streamthoughts.kafka.connect.filepulse.expression.function.Arguments;
import io.streamthoughts.kafka.connect.filepulse.expression.function.EvaluatedExecutionContext;
import io.streamthoughts.kafka.connect.filepulse.expression.function.ExpressionFunction;
import java.util.Objects;
import java.util.regex.Pattern;

public class Matches
implements ExpressionFunction {
    private static final String FIELD_ARG = "field_expr";
    private static final String PATTERN_ARG = "pattern";

    @Override
    public ExpressionFunction.Instance get() {
        return new Instance(this.name());
    }

    static class Instance
    extends AbstractExpressionFunctionInstance {
        private Pattern pattern;
        private final String name;

        public Instance(String name) {
            this.name = Objects.requireNonNull(name, "'name' should not be null");
        }

        private String syntax() {
            return String.format("syntax %s(<%s>, <%s>)", this.name, Matches.FIELD_ARG, Matches.PATTERN_ARG);
        }

        @Override
        public Arguments prepare(Expression[] args) {
            if (args.length > 2) {
                throw new ExpressionException("Too many arguments: " + this.syntax());
            }
            if (args.length < 2) {
                throw new ExpressionException("Missing required arguments: " + this.syntax());
            }
            this.pattern = Pattern.compile(((ValueExpression)args[1]).value().getString());
            return Arguments.of(Matches.FIELD_ARG, args[0]);
        }

        @Override
        public TypedValue invoke(EvaluatedExecutionContext context) throws ExpressionException {
            String value = (String)context.get(0).value();
            return TypedValue.bool((Boolean)this.pattern.matcher(value).matches());
        }
    }
}

