/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.expression.function.strings;

import io.streamthoughts.kafka.connect.filepulse.data.Type;
import io.streamthoughts.kafka.connect.filepulse.data.TypedValue;
import io.streamthoughts.kafka.connect.filepulse.expression.Expression;
import io.streamthoughts.kafka.connect.filepulse.expression.ExpressionException;
import io.streamthoughts.kafka.connect.filepulse.expression.ValueExpression;
import io.streamthoughts.kafka.connect.filepulse.expression.function.AbstractExpressionFunctionInstance;
import io.streamthoughts.kafka.connect.filepulse.expression.function.Arguments;
import io.streamthoughts.kafka.connect.filepulse.expression.function.EvaluatedExecutionContext;
import io.streamthoughts.kafka.connect.filepulse.expression.function.ExpressionFunction;
import io.streamthoughts.kafka.connect.filepulse.internal.StringUtils;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;

public class Split
implements ExpressionFunction {
    @Override
    public ExpressionFunction.Instance get() {
        return new SplitInstance(this.name());
    }

    static class SplitInstance
    extends AbstractExpressionFunctionInstance {
        private static final String FIELD_ARG = "field_expr";
        private static final String REGEX_ARG = "separator";
        private static final String LIMIT_ARG = "limit";
        private final String name;
        private Function<String, String[]> function;

        SplitInstance(String name) {
            this.name = Objects.requireNonNull(name, "'name' should not be null");
        }

        private String syntax() {
            return String.format("syntax %s(%s, %s [, %s])", this.name, FIELD_ARG, REGEX_ARG, LIMIT_ARG);
        }

        @Override
        public Arguments prepare(Expression[] args) {
            if (args.length > 3) {
                throw new ExpressionException("Too many arguments: " + this.syntax());
            }
            if (args.length < 2) {
                throw new ExpressionException("Missing required arguments: " + this.syntax());
            }
            int limit = args.length == 3 ? ((ValueExpression)args[2]).value().getInt() : 0;
            String regex = ((ValueExpression)args[1]).value().getString();
            if (StringUtils.isFastSplit((String)regex)) {
                this.function = s -> s.split(regex, limit);
            } else {
                Pattern splitPattern = Pattern.compile(regex);
                this.function = s -> splitPattern.split((CharSequence)s, limit);
            }
            return Arguments.of(FIELD_ARG, args[0]);
        }

        @Override
        public TypedValue invoke(EvaluatedExecutionContext context) throws ExpressionException {
            String field = context.get(0).getString();
            return TypedValue.array(Arrays.asList(this.function.apply(field)), (Type)Type.STRING);
        }
    }
}

