/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.expression.function.strings;

import io.streamthoughts.kafka.connect.filepulse.data.TypedValue;
import io.streamthoughts.kafka.connect.filepulse.expression.Expression;
import io.streamthoughts.kafka.connect.filepulse.expression.ExpressionException;
import io.streamthoughts.kafka.connect.filepulse.expression.function.AbstractExpressionFunctionInstance;
import io.streamthoughts.kafka.connect.filepulse.expression.function.Arguments;
import io.streamthoughts.kafka.connect.filepulse.expression.function.EvaluatedExecutionContext;
import io.streamthoughts.kafka.connect.filepulse.expression.function.ExpressionFunction;

public class StartsWith
implements ExpressionFunction {
    private static final String FIELD_ARG = "field_expr";
    private static final String PREFIX_ARG = "prefix";

    @Override
    public ExpressionFunction.Instance get() {
        return new AbstractExpressionFunctionInstance(){

            private String syntax() {
                return String.format("syntax %s(<%s>, <%s>)", StartsWith.this.name(), StartsWith.FIELD_ARG, StartsWith.PREFIX_ARG);
            }

            @Override
            public Arguments prepare(Expression[] args) {
                if (args.length > 2) {
                    throw new ExpressionException("Too many arguments: " + this.syntax());
                }
                if (args.length < 2) {
                    throw new ExpressionException("Missing required arguments: " + this.syntax());
                }
                return Arguments.of(StartsWith.FIELD_ARG, args[0], StartsWith.PREFIX_ARG, args[1]);
            }

            @Override
            public TypedValue invoke(EvaluatedExecutionContext context) throws ExpressionException {
                TypedValue field = context.get(0);
                TypedValue prefix = context.get(1);
                return TypedValue.bool((Boolean)field.getString().startsWith(prefix.getString()));
            }
        };
    }
}

