/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.expression.parser.antlr4;

import io.streamthoughts.kafka.connect.filepulse.data.TypedValue;
import io.streamthoughts.kafka.connect.filepulse.expression.Expression;
import io.streamthoughts.kafka.connect.filepulse.expression.ExpressionException;
import io.streamthoughts.kafka.connect.filepulse.expression.FunctionExpression;
import io.streamthoughts.kafka.connect.filepulse.expression.PropertyExpression;
import io.streamthoughts.kafka.connect.filepulse.expression.SubstitutionExpression;
import io.streamthoughts.kafka.connect.filepulse.expression.ValueExpression;
import io.streamthoughts.kafka.connect.filepulse.expression.function.ExpressionFunctionExecutor;
import io.streamthoughts.kafka.connect.filepulse.expression.function.ExpressionFunctionExecutors;
import io.streamthoughts.kafka.connect.filepulse.expression.parser.ExpressionParser;
import io.streamthoughts.kafka.connect.filepulse.expression.parser.ScELParseCancellationException;
import io.streamthoughts.kafka.connect.filepulse.expression.parser.antlr4.ScELLexer;
import io.streamthoughts.kafka.connect.filepulse.expression.parser.antlr4.ScELParser;
import io.streamthoughts.kafka.connect.filepulse.expression.parser.antlr4.ScELParserBaseListener;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.BufferedTokenStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class Antlr4ExpressionParser
implements ExpressionParser {
    private static final String DEFAULT_ROOT_OBJECT = "value";

    @Override
    public Expression parseExpression(String expression) throws ExpressionException {
        return this.parseExpression(expression, DEFAULT_ROOT_OBJECT);
    }

    public Expression parseExpression(String expression, String defaultScope) throws ExpressionException {
        CodePointCharStream cs = CharStreams.fromString((String)expression);
        ScELLexer lexer = new ScELLexer((CharStream)cs);
        ScELParser parser = new ScELParser((TokenStream)new BufferedTokenStream((TokenSource)lexer));
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)new ThrowingErrorListener(expression));
        ParseTreeWalker walker = new ParseTreeWalker();
        ExpressionProvider factory = new ExpressionProvider(expression, defaultScope);
        walker.walk((ParseTreeListener)factory, (ParseTree)parser.scel());
        return factory.expression();
    }

    private static class ContextExpressions {
        final ContextExpressions parent;
        final ArrayDeque<Expression> expressions = new ArrayDeque();

        ContextExpressions(ContextExpressions parent) {
            this.parent = parent;
        }
    }

    private static class ExpressionProvider
    extends ScELParserBaseListener {
        public static final String NULL_STRING = "null";
        private final String originalExpression;
        private final String defaultScope;
        private final IdentityHashMap<ParserRuleContext, ContextExpressions> contexts = new IdentityHashMap();
        private ContextExpressions current = new ContextExpressions(null);

        ExpressionProvider(String originalExpression, String defaultScope) {
            this.originalExpression = originalExpression;
            this.defaultScope = defaultScope;
        }

        public Expression expression() {
            if (this.current.expressions.isEmpty()) {
                throw new ExpressionException("Invalid expression after parsing:" + this.originalExpression + ". Empty result");
            }
            if (this.current.expressions.size() > 1) {
                throw new ExpressionException("Invalid expression after parsing:" + this.originalExpression + ". Too many results");
            }
            return this.current.expressions.remove();
        }

        @Override
        public void exitSubstitutionExpression(ScELParser.SubstitutionExpressionContext ctx) {
            SubstitutionExpression substitution = new SubstitutionExpression(this.originalExpression);
            while (!this.current.expressions.isEmpty()) {
                SubstitutionExpression.ReplacementExpression expression = (SubstitutionExpression.ReplacementExpression)this.current.expressions.poll();
                substitution.addReplacement(expression);
            }
            this.current.expressions.add(substitution);
        }

        @Override
        public void enterSubstitutionStrExpression(ScELParser.SubstitutionStrExpressionContext ctx) {
            this.current = new ContextExpressions(this.current);
            this.contexts.put(ctx, this.current);
        }

        @Override
        public void exitSubstitutionStrExpression(ScELParser.SubstitutionStrExpressionContext ctx) {
            ContextExpressions contextExpression = this.contexts.remove((Object)ctx);
            int start = ctx.LineSubstExprStart().getSymbol().getStartIndex();
            int stop = ctx.LineSubstExprEnd().getSymbol().getStopIndex() + 1;
            ArrayList<Expression> expressions = new ArrayList<Expression>();
            while (!this.current.expressions.isEmpty()) {
                expressions.add(this.current.expressions.remove());
            }
            SubstitutionExpression.ReplacementExpression expression = new SubstitutionExpression.ReplacementExpression(ctx.getText(), start, stop, expressions);
            if (contextExpression.parent != null) {
                contextExpression.parent.expressions.add(expression);
                this.current = contextExpression.parent;
            } else {
                this.current.expressions.add(expression);
            }
        }

        @Override
        public void enterFunctionDeclaration(ScELParser.FunctionDeclarationContext ctx) {
            this.current = new ContextExpressions(this.current);
            this.contexts.put(ctx, this.current);
        }

        @Override
        public void exitFunctionDeclaration(ScELParser.FunctionDeclarationContext ctx) {
            ContextExpressions contextExpression = this.contexts.remove((Object)ctx);
            ArrayDeque<Expression> argsExpressions = contextExpression.expressions;
            ArrayList<Expression> arguments = new ArrayList<Expression>(argsExpressions.size());
            while (!argsExpressions.isEmpty()) {
                arguments.add(argsExpressions.remove());
            }
            ExpressionFunctionExecutor executor = ExpressionFunctionExecutors.resolve(ctx.Identifier().getText(), arguments.toArray(new Expression[0]));
            FunctionExpression expression = new FunctionExpression(ctx.getText(), executor);
            if (contextExpression.parent != null) {
                contextExpression.parent.expressions.add(expression);
                this.current = contextExpression.parent;
            } else {
                this.current.expressions.add(expression);
            }
        }

        @Override
        public void exitPropertyDeclaration(ScELParser.PropertyDeclarationContext ctx) {
            PropertyExpression expression = new PropertyExpression(ctx.getText(), ctx.scope() != null ? ctx.scope().getText() : this.defaultScope, ctx.attribute() != null ? ctx.attribute().getText() : null);
            this.current.expressions.add(expression);
        }

        @Override
        public void exitValue(ScELParser.ValueContext ctx) {
            Object value;
            String originalExpression = ctx.getText();
            if (originalExpression.equalsIgnoreCase(NULL_STRING)) {
                value = null;
            } else if (originalExpression.startsWith("'") && originalExpression.endsWith("'")) {
                String s = originalExpression.substring(1);
                value = s.substring(0, s.length() - 1);
            } else {
                value = TypedValue.parse((String)originalExpression).value();
            }
            this.current.expressions.add(new ValueExpression(originalExpression, value));
        }
    }

    public static class ThrowingErrorListener
    extends BaseErrorListener {
        private final String expression;

        ThrowingErrorListener(String expression) {
            this.expression = expression;
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) throws ScELParseCancellationException {
            throw new ScELParseCancellationException("Cannot parse ScEL expression '" + this.expression + "' : line " + line + ":" + charPositionInLine + " " + msg);
        }
    }
}

