/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.filter.condition;

import io.streamthoughts.kafka.connect.filepulse.data.DataException;
import io.streamthoughts.kafka.connect.filepulse.data.TypedStruct;
import io.streamthoughts.kafka.connect.filepulse.data.TypedValue;
import io.streamthoughts.kafka.connect.filepulse.expression.Expression;
import io.streamthoughts.kafka.connect.filepulse.expression.StandardEvaluationContext;
import io.streamthoughts.kafka.connect.filepulse.expression.parser.ExpressionParsers;
import io.streamthoughts.kafka.connect.filepulse.filter.FilterContext;
import io.streamthoughts.kafka.connect.filepulse.filter.FilterException;
import io.streamthoughts.kafka.connect.filepulse.filter.InternalFilterContext;
import io.streamthoughts.kafka.connect.filepulse.filter.condition.FilterCondition;
import java.util.Objects;

public class ExpressionFilterCondition
implements FilterCondition {
    private final Expression expression;

    public ExpressionFilterCondition(String expression) {
        Objects.requireNonNull(expression, "expression can't be null");
        this.expression = ExpressionParsers.parseExpression(expression);
    }

    public boolean apply(FilterContext context, TypedStruct record) throws FilterException {
        Objects.requireNonNull(context, "context can not be null");
        Objects.requireNonNull(record, "record can not be null");
        InternalFilterContext internalContext = (InternalFilterContext)context;
        internalContext.setValue(record);
        StandardEvaluationContext ec = new StandardEvaluationContext(internalContext, context.variables());
        Object o = this.expression.readValue(ec);
        TypedValue value = o instanceof TypedValue ? (TypedValue)o : TypedValue.any((Object)o);
        try {
            return value.getBool();
        }
        catch (DataException e) {
            throw new FilterException("Invalid condition function result type, expecting boolean value - got : " + String.valueOf(o));
        }
    }
}

