/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.transform;

import io.streamthoughts.kafka.connect.transform.GrokConfig;
import io.streamthoughts.kafka.connect.transform.pattern.GrokException;
import io.streamthoughts.kafka.connect.transform.pattern.GrokMatcher;
import io.streamthoughts.kafka.connect.transform.pattern.GrokPatternCompiler;
import io.streamthoughts.kafka.connect.transform.pattern.GrokPatternResolver;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.transforms.Transformation;

public abstract class Grok<R extends ConnectRecord<R>>
implements Transformation<R> {
    private GrokPatternCompiler compiler;
    private List<GrokMatcher> matchPatterns;
    private GrokConfig config;

    protected SchemaAndValue process(Schema inputSchema, Object inputValue) {
        if (inputSchema == null && inputValue == null) {
            return new SchemaAndValue(null, null);
        }
        if (Schema.Type.STRING != inputSchema.type()) {
            throw new UnsupportedOperationException(inputSchema.type() + " is not a supported type.");
        }
        byte[] bytes = ((String)inputValue).getBytes(StandardCharsets.UTF_8);
        ArrayList<SchemaAndNamedCaptured> allNamedCaptured = new ArrayList<SchemaAndNamedCaptured>(this.matchPatterns.size());
        for (GrokMatcher matcher : this.matchPatterns) {
            Map<String, Object> captured = matcher.captures(bytes);
            if (captured == null) continue;
            allNamedCaptured.add(new SchemaAndNamedCaptured(matcher.schema(), captured));
            if (!this.config.breakOnFirstPattern()) continue;
            break;
        }
        if (allNamedCaptured.isEmpty()) {
            throw new GrokException("Supplied Grok patterns does not match input data: " + inputSchema);
        }
        Schema schema = this.mergeToSchema(allNamedCaptured);
        return new SchemaAndValue(schema, (Object)this.mergeToStruct(allNamedCaptured, schema));
    }

    private Struct mergeToStruct(List<SchemaAndNamedCaptured> allNamedCaptured, Schema schema) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        for (SchemaAndNamedCaptured schemaAndNamedCaptured : allNamedCaptured) {
            schemaAndNamedCaptured.namedCaptured().forEach((name, value) -> {
                Field field = schema.field(name);
                if (field.schema().type() == Schema.Type.ARRAY) {
                    ((List)fields.computeIfAbsent((String)name, k -> new ArrayList())).add(value);
                } else {
                    fields.put((String)name, value);
                }
            });
        }
        Struct struct = new Struct(schema);
        fields.forEach((arg_0, arg_1) -> ((Struct)struct).put(arg_0, arg_1));
        return struct;
    }

    private Schema mergeToSchema(List<SchemaAndNamedCaptured> allNamedCaptured) {
        if (allNamedCaptured.size() == 1) {
            return allNamedCaptured.get(0).schema();
        }
        HashMap<String, Schema> fields = new HashMap<String, Schema>();
        for (SchemaAndNamedCaptured namedCaptured : allNamedCaptured) {
            Schema schema = namedCaptured.schema();
            schema.fields().forEach(f -> {
                Schema fieldSchema = fields.containsKey(f.name()) ? SchemaBuilder.array((Schema)f.schema()) : f.schema();
                fields.put(f.name(), fieldSchema);
            });
        }
        SchemaBuilder schema = SchemaBuilder.struct();
        fields.forEach((arg_0, arg_1) -> ((SchemaBuilder)schema).field(arg_0, arg_1));
        return schema.build();
    }

    public ConfigDef config() {
        return GrokConfig.configDef();
    }

    public void close() {
    }

    public void configure(Map<String, ?> props) {
        this.config = new GrokConfig(props);
        this.compiler = new GrokPatternCompiler(new GrokPatternResolver(this.config.patternDefinitions(), this.config.patternsDir()), this.config.namedCapturesOnly());
        this.matchPatterns = this.config.patterns().stream().map(pattern -> this.compiler.compile((String)pattern)).collect(Collectors.toList());
    }

    private static class SchemaAndNamedCaptured {
        private final Schema schema;
        private final Map<String, Object> namedCaptured;

        public SchemaAndNamedCaptured(Schema schema, Map<String, Object> namedCaptured) {
            this.schema = schema;
            this.namedCaptured = namedCaptured;
        }

        public Schema schema() {
            return this.schema;
        }

        public Map<String, Object> namedCaptured() {
            return this.namedCaptured;
        }
    }

    public static class Value<R extends ConnectRecord<R>>
    extends Grok<R> {
        public R apply(R r) {
            SchemaAndValue transformed = this.process(r.valueSchema(), r.value());
            return (R)r.newRecord(r.topic(), r.kafkaPartition(), r.keySchema(), r.key(), transformed.schema(), transformed.value(), r.timestamp());
        }
    }

    public static class Key<R extends ConnectRecord<R>>
    extends Grok<R> {
        public R apply(R r) {
            SchemaAndValue transformed = this.process(r.keySchema(), r.key());
            return (R)r.newRecord(r.topic(), r.kafkaPartition(), transformed.schema(), transformed.value(), r.valueSchema(), r.value(), r.timestamp());
        }
    }
}

