/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.transform.pattern;

import io.streamthoughts.kafka.connect.transform.data.Type;
import io.streamthoughts.kafka.connect.transform.pattern.GrokCaptureExtractor;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;
import org.joni.Region;

public class GrokCaptureGroup {
    private final Type type;
    private final String name;
    private final int[] backRefs;

    public GrokCaptureGroup(String name, int[] backRefs, Type type) {
        this.type = Objects.requireNonNull(type, "type cannot be null");
        this.name = Objects.requireNonNull(name, "name cannot be null");
        this.backRefs = backRefs;
    }

    public Type type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public GrokCaptureExtractor getExtractor(Consumer<Object> consumer) {
        return new RawValueExtractor(this.backRefs, s -> consumer.accept(this.type.convert(s)));
    }

    public String toString() {
        return "GrokCaptureGroup{type=" + this.type + ", name='" + this.name + "', backRefs=" + Arrays.toString(this.backRefs) + "}";
    }

    private static class RawValueExtractor
    implements GrokCaptureExtractor {
        final int[] backRefs;
        final Consumer<String> consumer;

        public RawValueExtractor(int[] backRefs, Consumer<String> consumer) {
            this.backRefs = backRefs;
            this.consumer = consumer;
        }

        @Override
        public void extract(byte[] bytes, Region region) {
            for (int capture : this.backRefs) {
                int offset = region.beg[capture];
                int length = region.end[capture] - region.beg[capture];
                if (offset < 0) continue;
                String value = new String(bytes, offset, length, StandardCharsets.UTF_8);
                this.consumer.accept(value);
                break;
            }
        }
    }
}

