/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.client.schedules;

import io.temporal.api.enums.v1.ScheduleOverlapPolicy;
import java.time.Duration;
import java.util.Objects;

public final class SchedulePolicy {
    private final ScheduleOverlapPolicy overlap;
    private final Duration catchupWindow;
    private final boolean pauseOnFailure;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(SchedulePolicy options) {
        return new Builder(options);
    }

    private SchedulePolicy(ScheduleOverlapPolicy overlap, Duration catchupWindow, boolean pauseOnFailure) {
        this.overlap = overlap;
        this.catchupWindow = catchupWindow;
        this.pauseOnFailure = pauseOnFailure;
    }

    public ScheduleOverlapPolicy getOverlap() {
        return this.overlap;
    }

    public Duration getCatchupWindow() {
        return this.catchupWindow;
    }

    public boolean isPauseOnFailure() {
        return this.pauseOnFailure;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchedulePolicy that = (SchedulePolicy)o;
        return this.pauseOnFailure == that.pauseOnFailure && this.overlap == that.overlap && Objects.equals(this.catchupWindow, that.catchupWindow);
    }

    public int hashCode() {
        return Objects.hash(this.overlap, this.catchupWindow, this.pauseOnFailure);
    }

    public String toString() {
        return "SchedulePolicy{overlap=" + this.overlap + ", catchupWindow=" + this.catchupWindow + ", pauseOnFailure=" + this.pauseOnFailure + '}';
    }

    public static final class Builder {
        private ScheduleOverlapPolicy overlap;
        private Duration catchupWindow;
        private boolean pauseOnFailure;

        private Builder() {
        }

        private Builder(SchedulePolicy options) {
            if (options == null) {
                return;
            }
            this.overlap = options.overlap;
            this.catchupWindow = options.catchupWindow;
            this.pauseOnFailure = options.pauseOnFailure;
        }

        public Builder setOverlap(ScheduleOverlapPolicy overlap) {
            this.overlap = overlap;
            return this;
        }

        public Builder setCatchupWindow(Duration catchupWindow) {
            this.catchupWindow = catchupWindow;
            return this;
        }

        public Builder setPauseOnFailure(boolean pauseOnFailure) {
            this.pauseOnFailure = pauseOnFailure;
            return this;
        }

        public SchedulePolicy build() {
            return new SchedulePolicy(this.overlap == null ? ScheduleOverlapPolicy.SCHEDULE_OVERLAP_POLICY_SKIP : this.overlap, this.catchupWindow, this.pauseOnFailure);
        }
    }
}

