/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.failure;

import com.google.common.base.Strings;
import io.temporal.common.converter.DataConverter;
import io.temporal.common.converter.EncodedValues;
import io.temporal.common.converter.Values;
import io.temporal.failure.TemporalFailure;
import java.time.Duration;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ApplicationFailure
extends TemporalFailure {
    private final String type;
    private final Values details;
    private boolean nonRetryable;
    private Duration nextRetryDelay;

    public static ApplicationFailure newFailure(String message, String type, Object ... details) {
        return ApplicationFailure.newFailureWithCause(message, type, null, details);
    }

    public static ApplicationFailure newFailureWithCause(String message, String type, @Nullable Throwable cause, Object ... details) {
        return new ApplicationFailure(message, type, false, new EncodedValues(details), cause, null);
    }

    public static ApplicationFailure newFailureWithCauseAndDelay(String message, String type, @Nullable Throwable cause, Duration nextRetryDelay, Object ... details) {
        return new ApplicationFailure(message, type, false, new EncodedValues(details), cause, nextRetryDelay);
    }

    public static ApplicationFailure newNonRetryableFailure(String message, String type, Object ... details) {
        return ApplicationFailure.newNonRetryableFailureWithCause(message, type, null, details);
    }

    public static ApplicationFailure newNonRetryableFailureWithCause(String message, String type, @Nullable Throwable cause, Object ... details) {
        return new ApplicationFailure(message, type, true, new EncodedValues(details), cause, null);
    }

    static ApplicationFailure newFromValues(String message, String type, boolean nonRetryable, Values details, Throwable cause, Duration nextRetryDelay) {
        return new ApplicationFailure(message, type, nonRetryable, details, cause, nextRetryDelay);
    }

    ApplicationFailure(String message, String type, boolean nonRetryable, Values details, Throwable cause, Duration nextRetryDelay) {
        super(ApplicationFailure.getMessage(message, Objects.requireNonNull(type), nonRetryable), message, cause);
        this.type = type;
        this.details = details;
        this.nonRetryable = nonRetryable;
        this.nextRetryDelay = nextRetryDelay;
    }

    public String getType() {
        return this.type;
    }

    public Values getDetails() {
        return this.details;
    }

    @Nullable
    public Duration getNextRetryDelay() {
        return this.nextRetryDelay;
    }

    public void setNonRetryable(boolean nonRetryable) {
        this.nonRetryable = nonRetryable;
    }

    public boolean isNonRetryable() {
        return this.nonRetryable;
    }

    @Override
    public void setDataConverter(DataConverter converter) {
        ((EncodedValues)this.details).setDataConverter(converter);
    }

    public void setNextRetryDelay(Duration nextRetryDelay) {
        this.nextRetryDelay = nextRetryDelay;
    }

    private static String getMessage(String message, String type, boolean nonRetryable) {
        return (Strings.isNullOrEmpty((String)message) ? "" : "message='" + message + "', ") + "type='" + type + '\'' + ", nonRetryable=" + nonRetryable;
    }
}

