/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.statemachines;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.temporal.api.command.v1.RecordMarkerCommandAttributes;
import io.temporal.api.enums.v1.CommandType;
import io.temporal.api.enums.v1.EventType;
import io.temporal.api.history.v1.HistoryEvent;
import io.temporal.internal.history.VersionMarkerUtils;
import io.temporal.internal.statemachines.CancellableCommand;
import io.temporal.internal.statemachines.EntityStateMachineInitialCommand;
import io.temporal.internal.statemachines.StateMachine;
import io.temporal.internal.statemachines.StateMachineCommandUtils;
import io.temporal.internal.statemachines.StateMachineDefinition;
import io.temporal.internal.statemachines.UnsupportedVersion;
import io.temporal.internal.statemachines.WorkflowStateMachines;
import io.temporal.worker.NonDeterministicException;
import io.temporal.workflow.Functions;
import java.util.Objects;
import javax.annotation.Nullable;

final class VersionStateMachine {
    private static final String RETROACTIVE_ADDITION_ERROR_STRING = "The most probable cause is retroactive addition of a getVersion call with an existing 'changeId'";
    private final String changeId;
    private final Functions.Func<Boolean> replaying;
    private final Functions.Proc1<CancellableCommand> commandSink;
    private final Functions.Proc1<StateMachine> stateMachineSink;
    @Nullable
    private Integer version;
    @Nullable
    private Integer preloadedVersion;
    public static final StateMachineDefinition<State, ExplicitEvent, InvocationStateMachine> STATE_MACHINE_DEFINITION = StateMachineDefinition.newInstance("Version", State.CREATED, State.MARKER_COMMAND_RECORDED, State.SKIPPED_NOTIFIED).add(State.CREATED, ExplicitEvent.CHECK_EXECUTION_STATE, (State[])new State[]{State.REPLAYING, State.EXECUTING}, InvocationStateMachine::getExecutionState).add(State.EXECUTING, ExplicitEvent.SCHEDULE, (State[])new State[]{State.MARKER_COMMAND_CREATED, State.SKIPPED}, InvocationStateMachine::createMarkerExecuting).add(State.MARKER_COMMAND_CREATED, CommandType.COMMAND_TYPE_RECORD_MARKER, State.RESULT_NOTIFIED, InvocationStateMachine::notifyFromVersionExecuting).add(State.RESULT_NOTIFIED, EventType.EVENT_TYPE_MARKER_RECORDED, State.MARKER_COMMAND_RECORDED).add(State.SKIPPED, CommandType.COMMAND_TYPE_RECORD_MARKER, State.SKIPPED_NOTIFIED, InvocationStateMachine::notifySkippedExecuting).add(State.REPLAYING, ExplicitEvent.SCHEDULE, (State[])new State[]{State.MARKER_COMMAND_CREATED_REPLAYING, State.SKIPPED_REPLAYING}, InvocationStateMachine::createMarkerReplaying).add(State.MARKER_COMMAND_CREATED_REPLAYING, CommandType.COMMAND_TYPE_RECORD_MARKER, State.RESULT_NOTIFIED_REPLAYING, InvocationStateMachine::notifyMarkerCreatedReplaying).add(State.RESULT_NOTIFIED_REPLAYING, EventType.EVENT_TYPE_MARKER_RECORDED, State.MARKER_COMMAND_RECORDED, InvocationStateMachine::flushPreloadedVersionAndUpdateFromEventReplaying).add(State.RESULT_NOTIFIED_REPLAYING, ExplicitEvent.NON_MATCHING_EVENT, State.SKIPPED_NOTIFIED, InvocationStateMachine::missingMarkerReplaying).add(State.SKIPPED_REPLAYING, CommandType.COMMAND_TYPE_RECORD_MARKER, State.SKIPPED_NOTIFIED, InvocationStateMachine::notifySkippedReplaying);

    private void updateVersionFromEvent(HistoryEvent event) {
        if (this.version != null) {
            throw new NonDeterministicException("Version is already set to " + this.version + ". " + RETROACTIVE_ADDITION_ERROR_STRING);
        }
        this.version = this.getVersionFromEvent(event);
    }

    private void preloadVersionFromEvent(HistoryEvent event) {
        if (this.version != null) {
            throw new NonDeterministicException("Version is already set to " + this.version + ". " + RETROACTIVE_ADDITION_ERROR_STRING);
        }
        Preconditions.checkState((this.preloadedVersion == null ? 1 : 0) != 0, (String)"Preloaded version is already set to %s. Most likely the history has several version marker events for the same 'changeId'", (Object)this.preloadedVersion);
        this.preloadedVersion = this.getVersionFromEvent(event);
    }

    void flushPreloadedVersionAndUpdateFromEvent(HistoryEvent event) {
        this.updateVersionFromEvent(event);
        this.preloadedVersion = null;
    }

    public static VersionStateMachine newInstance(String id, Functions.Func<Boolean> replaying, Functions.Proc1<CancellableCommand> commandSink, Functions.Proc1<StateMachine> stateMachineSink) {
        return new VersionStateMachine(id, replaying, commandSink, stateMachineSink);
    }

    private VersionStateMachine(String changeId, Functions.Func<Boolean> replaying, Functions.Proc1<CancellableCommand> commandSink, Functions.Proc1<StateMachine> stateMachineSink) {
        this.changeId = Objects.requireNonNull(changeId);
        this.replaying = Objects.requireNonNull(replaying);
        this.commandSink = Objects.requireNonNull(commandSink);
        this.stateMachineSink = stateMachineSink;
    }

    public boolean getVersion(int minSupported, int maxSupported, Functions.Proc2<Integer, RuntimeException> callback) {
        InvocationStateMachine ism = new InvocationStateMachine(minSupported, maxSupported, callback);
        ism.explicitEvent(ExplicitEvent.CHECK_EXECUTION_STATE);
        ism.explicitEvent(ExplicitEvent.SCHEDULE);
        return ism.getState() != State.SKIPPED_REPLAYING || this.version != null;
    }

    public void handleNonMatchingEvent(HistoryEvent event) {
        this.flushPreloadedVersionAndUpdateFromEvent(event);
    }

    public void handleMarkersPreload(HistoryEvent event) {
        this.preloadVersionFromEvent(event);
    }

    private int getVersionFromEvent(HistoryEvent event) {
        Preconditions.checkArgument((boolean)VersionMarkerUtils.hasVersionMarkerStructure(event), (String)"Expected a version marker event, got %s with '%s' marker name", (Object)event.getEventType(), (Object)event.getMarkerRecordedEventAttributes().getMarkerName());
        String eventChangeId = VersionMarkerUtils.getChangeId(event.getMarkerRecordedEventAttributes());
        Preconditions.checkArgument((boolean)this.changeId.equals(eventChangeId), (String)"Got an event with an incorrect changeId, expected: %s, got %s", (Object)this.changeId, (Object)eventChangeId);
        Integer version = VersionMarkerUtils.getVersion(event.getMarkerRecordedEventAttributes());
        Preconditions.checkArgument((version != null ? 1 : 0) != 0, (Object)"Marker details missing required version key");
        return version;
    }

    @VisibleForTesting
    class InvocationStateMachine
    extends EntityStateMachineInitialCommand<State, ExplicitEvent, InvocationStateMachine> {
        private final int minSupported;
        private final int maxSupported;
        private final Functions.Proc2<Integer, RuntimeException> resultCallback;

        InvocationStateMachine(int minSupported, int maxSupported, Functions.Proc2<Integer, RuntimeException> callback) {
            super(STATE_MACHINE_DEFINITION, VersionStateMachine.this.commandSink, VersionStateMachine.this.stateMachineSink);
            this.minSupported = minSupported;
            this.maxSupported = maxSupported;
            this.resultCallback = Objects.requireNonNull(callback);
        }

        State getExecutionState() {
            return (Boolean)VersionStateMachine.this.replaying.apply() != false ? State.REPLAYING : State.EXECUTING;
        }

        @Override
        public WorkflowStateMachines.HandleEventStatus handleEvent(HistoryEvent event, boolean hasNextEvent) {
            if (!VersionMarkerUtils.hasVersionMarkerStructure(event)) {
                this.explicitEvent(ExplicitEvent.NON_MATCHING_EVENT);
                return WorkflowStateMachines.HandleEventStatus.NON_MATCHING_EVENT;
            }
            String expectedId = VersionMarkerUtils.getChangeId(event.getMarkerRecordedEventAttributes());
            if (Strings.isNullOrEmpty((String)expectedId)) {
                throw new IllegalStateException("Version machine found in the history, but it doesn't contain a change id");
            }
            if (!VersionStateMachine.this.changeId.equals(expectedId)) {
                return WorkflowStateMachines.HandleEventStatus.NON_MATCHING_EVENT;
            }
            return super.handleEvent(event, hasNextEvent);
        }

        @Override
        public void handleWorkflowTaskStarted() {
            if (this.getState() == State.RESULT_NOTIFIED_REPLAYING) {
                Preconditions.checkState((VersionStateMachine.this.preloadedVersion == null ? 1 : 0) != 0, (Object)"preloadedVersion is expected to be flushed or never set");
                this.explicitEvent(ExplicitEvent.NON_MATCHING_EVENT);
            }
        }

        void createFakeCommand() {
            this.addCommand(StateMachineCommandUtils.RECORD_MARKER_FAKE_COMMAND);
        }

        private void validateVersionAndThrow(boolean preloaded) {
            Integer versionToUse;
            Integer n = versionToUse = preloaded ? VersionStateMachine.this.preloadedVersion : VersionStateMachine.this.version;
            if (versionToUse == null) {
                throw new IllegalStateException((preloaded ? "preloaded " : "") + " version not set");
            }
            if (versionToUse < this.minSupported || versionToUse > this.maxSupported) {
                throw new UnsupportedVersion.UnsupportedVersionException(String.format("Version %d of changeId %s is not supported. Supported v is between %d and %d.", versionToUse, VersionStateMachine.this.changeId, this.minSupported, this.maxSupported));
            }
        }

        void notifyFromVersion(boolean preloaded) {
            Integer versionToUse = preloaded ? VersionStateMachine.this.preloadedVersion : VersionStateMachine.this.version;
            this.resultCallback.apply(versionToUse, null);
        }

        void notifyFromException(RuntimeException ex) {
            this.resultCallback.apply(null, ex);
        }

        void notifyFromVersionExecuting() {
            this.notifyFromVersion(false);
        }

        State createMarkerExecuting() {
            if (VersionStateMachine.this.version != null) {
                this.addCommand(StateMachineCommandUtils.RECORD_MARKER_FAKE_COMMAND);
                return State.SKIPPED;
            }
            VersionStateMachine.this.version = this.maxSupported;
            RecordMarkerCommandAttributes markerAttributes = VersionMarkerUtils.createMarkerAttributes(VersionStateMachine.this.changeId, VersionStateMachine.this.version);
            this.addCommand(StateMachineCommandUtils.createRecordMarker(markerAttributes));
            return State.MARKER_COMMAND_CREATED;
        }

        void notifySkippedExecuting() {
            this.cancelCommand();
            try {
                boolean usePreloadedVersion = false;
                this.validateVersionAndThrow(false);
                this.notifyFromVersion(false);
            }
            catch (RuntimeException ex) {
                this.notifyFromException(ex);
            }
        }

        void notifyMarkerCreatedReplaying() {
            try {
                boolean usePreloadedVersion = true;
                this.validateVersionAndThrow(true);
                this.notifyFromVersion(true);
            }
            catch (RuntimeException ex) {
                this.notifyFromException(ex);
            }
        }

        State createMarkerReplaying() {
            this.createFakeCommand();
            if (VersionStateMachine.this.preloadedVersion != null) {
                return State.MARKER_COMMAND_CREATED_REPLAYING;
            }
            return State.SKIPPED_REPLAYING;
        }

        void flushPreloadedVersionAndUpdateFromEventReplaying() {
            Preconditions.checkState((VersionStateMachine.this.preloadedVersion != null ? 1 : 0) != 0, (Object)"preloadedVersion is expected to be initialized");
            VersionStateMachine.this.flushPreloadedVersionAndUpdateFromEvent(this.currentEvent);
        }

        void notifySkippedReplaying() {
            this.cancelCommand();
            if (VersionStateMachine.this.version == null) {
                VersionStateMachine.this.version = -1;
            }
            try {
                boolean usePreloadedVersion = false;
                this.validateVersionAndThrow(false);
                this.notifyFromVersion(false);
            }
            catch (RuntimeException ex) {
                this.notifyFromException(ex);
            }
        }

        void missingMarkerReplaying() {
            if (VersionStateMachine.this.preloadedVersion != null) {
                throw new NonDeterministicException("getVersion call before the existing version marker event. The most probable cause is retroactive addition of a getVersion call with an existing 'changeId'");
            }
            this.cancelCommand();
        }
    }

    static enum State {
        CREATED,
        EXECUTING,
        MARKER_COMMAND_CREATED,
        SKIPPED,
        RESULT_NOTIFIED,
        REPLAYING,
        MARKER_COMMAND_CREATED_REPLAYING,
        SKIPPED_REPLAYING,
        RESULT_NOTIFIED_REPLAYING,
        MARKER_COMMAND_RECORDED,
        SKIPPED_NOTIFIED;

    }

    static enum ExplicitEvent {
        CHECK_EXECUTION_STATE,
        SCHEDULE,
        NON_MATCHING_EVENT;

    }
}

