/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.postgres;

import io.zonky.test.db.logging.EmbeddedDatabaseReporter;
import io.zonky.test.db.provider.DatabaseDescriptor;
import io.zonky.test.db.provider.DatabasePreparer;
import io.zonky.test.db.provider.GenericDatabaseProvider;
import javax.sql.DataSource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;

public class EmptyEmbeddedPostgresDataSourceFactoryBean
implements FactoryBean<DataSource>,
BeanFactoryAware {
    protected final DatabaseDescriptor databaseDescriptor;
    private BeanFactory beanFactory;
    private DataSource dataSource;

    public EmptyEmbeddedPostgresDataSourceFactoryBean(DatabaseDescriptor databaseDescriptor) {
        this.databaseDescriptor = databaseDescriptor;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public boolean isSingleton() {
        return true;
    }

    public Class<?> getObjectType() {
        return DataSource.class;
    }

    public DataSource getObject() throws Exception {
        if (this.dataSource == null) {
            GenericDatabaseProvider databaseProvider = (GenericDatabaseProvider)this.beanFactory.getBean(GenericDatabaseProvider.class);
            this.dataSource = databaseProvider.getDatabase(EmptyDatabasePreparer.INSTANCE, this.databaseDescriptor);
            EmbeddedDatabaseReporter.reportDataSource(this.dataSource);
        }
        return this.dataSource;
    }

    private static class EmptyDatabasePreparer
    implements DatabasePreparer {
        public static final EmptyDatabasePreparer INSTANCE = new EmptyDatabasePreparer();

        private EmptyDatabasePreparer() {
        }

        @Override
        public void prepare(DataSource dataSource) {
        }
    }
}

