/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.provider;

import java.util.Objects;
import org.springframework.util.Assert;

public final class DatabaseType {
    public static final DatabaseType POSTGRES = DatabaseType.valueOf("postgres");
    private final String name;

    public static DatabaseType valueOf(String name) {
        Assert.notNull((Object)name, (String)"Database name must not be null");
        return new DatabaseType(name.toLowerCase());
    }

    private DatabaseType(String name) {
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatabaseType that = (DatabaseType)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return this.name;
    }
}

