/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.provider.impl;

import com.cedarsoftware.util.DeepEquals;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import io.zonky.test.db.config.PostgreSQLContainerCustomizer;
import io.zonky.test.db.flyway.BlockingDataSourceWrapper;
import io.zonky.test.db.provider.DatabasePreparer;
import io.zonky.test.db.provider.DatabaseProvider;
import io.zonky.test.db.provider.DatabaseType;
import io.zonky.test.db.provider.ProviderType;
import io.zonky.test.db.util.PropertyUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Semaphore;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.lang3.RandomStringUtils;
import org.postgresql.ds.PGSimpleDataSource;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.core.env.Environment;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;

public class DockerPostgresDatabaseProvider
implements DatabaseProvider {
    private static final String DEFAULT_POSTGRES_USERNAME = "postgres";
    private static final String DEFAULT_POSTGRES_PASSWORD = "docker";
    private static final LoadingCache<DatabaseConfig, DatabaseInstance> databases = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<DatabaseConfig, DatabaseInstance>(){

        public DatabaseInstance load(DatabaseConfig config) {
            return new DatabaseInstance(config);
        }
    });
    private final DatabaseConfig databaseConfig;
    private final ClientConfig clientConfig;

    public DockerPostgresDatabaseProvider(Environment environment, ObjectProvider<List<PostgreSQLContainerCustomizer>> containerCustomizers) {
        String dockerImage = environment.getProperty("zonky.test.database.postgres.docker.image", "postgres:10.11-alpine");
        String tmpfsOptions = environment.getProperty("zonky.test.database.postgres.docker.tmpfs.options", "rw,noexec,nosuid");
        boolean tmpfsEnabled = (Boolean)environment.getProperty("zonky.test.database.postgres.docker.tmpfs.enabled", Boolean.TYPE, (Object)false);
        Map<String, String> initdbProperties = PropertyUtils.extractAll(environment, "zonky.test.database.postgres.initdb.properties");
        Map<String, String> configProperties = PropertyUtils.extractAll(environment, "zonky.test.database.postgres.server.properties");
        Map<String, String> connectProperties = PropertyUtils.extractAll(environment, "zonky.test.database.postgres.client.properties");
        List customizers = Optional.ofNullable(containerCustomizers.getIfAvailable()).orElse(Collections.emptyList());
        this.databaseConfig = new DatabaseConfig(dockerImage, tmpfsOptions, tmpfsEnabled, initdbProperties, configProperties, customizers);
        this.clientConfig = new ClientConfig(connectProperties);
    }

    @Override
    public DatabaseType getDatabaseType() {
        return DatabaseType.POSTGRES;
    }

    @Override
    public ProviderType getProviderType() {
        return ProviderType.DOCKER;
    }

    @Override
    public DataSource getDatabase(DatabasePreparer preparer) throws SQLException {
        DatabaseInstance instance = (DatabaseInstance)databases.getUnchecked((Object)this.databaseConfig);
        DatabaseInstance.DatabaseTemplate template = instance.getTemplate(this.clientConfig, preparer);
        return template.createDatabase();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DockerPostgresDatabaseProvider that = (DockerPostgresDatabaseProvider)o;
        return Objects.equals(this.databaseConfig, that.databaseConfig) && Objects.equals(this.clientConfig, that.clientConfig);
    }

    public int hashCode() {
        return Objects.hash(this.databaseConfig, this.clientConfig);
    }

    private static class ClientConfig {
        private final Map<String, String> connectProperties;

        private ClientConfig(Map<String, String> connectProperties) {
            this.connectProperties = ImmutableMap.copyOf(connectProperties);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClientConfig that = (ClientConfig)o;
            return Objects.equals(this.connectProperties, that.connectProperties);
        }

        public int hashCode() {
            return Objects.hash(this.connectProperties);
        }
    }

    private static class DatabaseConfig {
        private final String dockerImage;
        private final String tmpfsOptions;
        private final boolean tmpfsEnabled;
        private final Map<String, String> initdbProperties;
        private final Map<String, String> configProperties;
        private final List<PostgreSQLContainerCustomizer> customizers;

        private DatabaseConfig(String dockerImage, String tmpfsOptions, boolean tmpfsEnabled, Map<String, String> initdbProperties, Map<String, String> configProperties, List<PostgreSQLContainerCustomizer> customizers) {
            this.dockerImage = dockerImage;
            this.tmpfsOptions = tmpfsOptions;
            this.tmpfsEnabled = tmpfsEnabled;
            this.initdbProperties = ImmutableMap.copyOf(initdbProperties);
            this.configProperties = ImmutableMap.copyOf(configProperties);
            this.customizers = customizers;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DatabaseConfig that = (DatabaseConfig)o;
            return this.tmpfsEnabled == that.tmpfsEnabled && Objects.equals(this.dockerImage, that.dockerImage) && Objects.equals(this.tmpfsOptions, that.tmpfsOptions) && Objects.equals(this.initdbProperties, that.initdbProperties) && Objects.equals(this.configProperties, that.configProperties) && DeepEquals.deepEquals(this.customizers, that.customizers);
        }

        public int hashCode() {
            int result = Objects.hash(this.dockerImage, this.tmpfsOptions, this.tmpfsEnabled, this.initdbProperties, this.configProperties);
            result = 31 * result + DeepEquals.deepHashCode(this.customizers);
            return result;
        }
    }

    protected static class DatabaseInstance {
        private final PostgreSQLContainer container;
        private final Semaphore semaphore;
        private final LoadingCache<TemplateKey, DatabaseTemplate> templates = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<TemplateKey, DatabaseTemplate>(){

            public DatabaseTemplate load(TemplateKey key) throws Exception {
                return new DatabaseTemplate(key.config, key.preparer);
            }
        });

        private DatabaseInstance(DatabaseConfig config) {
            final String initdbArgs = config.initdbProperties.entrySet().stream().map(e -> String.format("--%s=%s", e.getKey(), e.getValue())).collect(Collectors.joining(" "));
            HashMap<String, String> serverProperties = new HashMap<String, String>(config.configProperties);
            serverProperties.putIfAbsent("fsync", "off");
            serverProperties.putIfAbsent("full_page_writes", "off");
            serverProperties.putIfAbsent("max_connections", "300");
            final String postgresArgs = serverProperties.entrySet().stream().map(e -> String.format("-c %s=%s", e.getKey(), e.getValue())).collect(Collectors.joining(" "));
            this.container = new PostgreSQLContainer(config.dockerImage){

                protected void configure() {
                    super.configure();
                    this.addEnv("POSTGRES_INITDB_ARGS", "--nosync " + initdbArgs);
                    this.setCommand("postgres " + postgresArgs);
                }
            };
            if (config.tmpfsEnabled) {
                Consumer<CreateContainerCmd> consumer = cmd -> cmd.getHostConfig().withTmpFs((Map)ImmutableMap.of((Object)"/var/lib/postgresql/data", (Object)config.tmpfsOptions));
                this.container.withCreateContainerCmdModifier(consumer);
            }
            this.container.withUsername(DockerPostgresDatabaseProvider.DEFAULT_POSTGRES_USERNAME);
            this.container.withPassword(DockerPostgresDatabaseProvider.DEFAULT_POSTGRES_PASSWORD);
            config.customizers.forEach(c -> c.customize(this.container));
            this.container.start();
            this.container.followOutput((Consumer)new Slf4jLogConsumer(LoggerFactory.getLogger(DockerPostgresDatabaseProvider.class)));
            this.semaphore = new Semaphore(Integer.parseInt((String)serverProperties.get("max_connections")));
        }

        public DatabaseTemplate getTemplate(ClientConfig config, DatabasePreparer preparer) {
            return (DatabaseTemplate)this.templates.getUnchecked((Object)new TemplateKey(config, preparer));
        }

        protected static class TemplateKey {
            private final ClientConfig config;
            private final DatabasePreparer preparer;

            private TemplateKey(ClientConfig config, DatabasePreparer preparer) {
                this.config = config;
                this.preparer = preparer;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                TemplateKey that = (TemplateKey)o;
                return Objects.equals(this.config, that.config) && Objects.equals(this.preparer, that.preparer);
            }

            public int hashCode() {
                return Objects.hash(this.config, this.preparer);
            }
        }

        protected class DatabaseTemplate {
            private final ClientConfig config;
            private final String templateName;

            private DatabaseTemplate(ClientConfig config, DatabasePreparer preparer) throws SQLException {
                this.config = config;
                this.templateName = RandomStringUtils.randomAlphabetic((int)12).toLowerCase(Locale.ENGLISH);
                this.executeStatement(String.format("CREATE DATABASE %s OWNER %s ENCODING 'utf8'", this.templateName, DockerPostgresDatabaseProvider.DEFAULT_POSTGRES_USERNAME));
                DataSource dataSource = this.getDatabase(this.templateName);
                preparer.prepare(dataSource);
            }

            public DataSource createDatabase() throws SQLException {
                String databaseName = RandomStringUtils.randomAlphabetic((int)12).toLowerCase(Locale.ENGLISH);
                this.executeStatement(String.format("CREATE DATABASE %s TEMPLATE %s OWNER %s ENCODING 'utf8'", databaseName, this.templateName, DockerPostgresDatabaseProvider.DEFAULT_POSTGRES_USERNAME));
                return this.getDatabase(databaseName);
            }

            private void executeStatement(String ddlStatement) throws SQLException {
                DataSource dataSource = this.getDatabase(DockerPostgresDatabaseProvider.DEFAULT_POSTGRES_USERNAME);
                try (Connection connection = dataSource.getConnection();
                     PreparedStatement stmt = connection.prepareStatement(ddlStatement);){
                    stmt.execute();
                }
            }

            private DataSource getDatabase(String dbName) throws SQLException {
                PGSimpleDataSource dataSource = new PGSimpleDataSource();
                dataSource.setServerName(DatabaseInstance.this.container.getContainerIpAddress());
                dataSource.setPortNumber(DatabaseInstance.this.container.getMappedPort(PostgreSQLContainer.POSTGRESQL_PORT.intValue()).intValue());
                dataSource.setDatabaseName(dbName);
                dataSource.setUser(DatabaseInstance.this.container.getUsername());
                dataSource.setPassword(DatabaseInstance.this.container.getPassword());
                for (Map.Entry entry : this.config.connectProperties.entrySet()) {
                    dataSource.setProperty((String)entry.getKey(), (String)entry.getValue());
                }
                return new BlockingDataSourceWrapper((DataSource)dataSource, DatabaseInstance.this.semaphore);
            }
        }
    }
}

