/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.stream.IntStream;
import org.springframework.test.util.AopTestUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MethodInvoker;

public class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static <T> T getField(Object targetObject, String name) {
        Assert.notNull((Object)targetObject, (String)"Target object must not be null");
        targetObject = AopTestUtils.getUltimateTargetObject((Object)targetObject);
        Class<?> targetClass = targetObject.getClass();
        Field field = org.springframework.util.ReflectionUtils.findField(targetClass, (String)name);
        if (field == null) {
            throw new IllegalArgumentException(String.format("Could not find field '%s' on %s", name, ReflectionUtils.safeToString(targetObject)));
        }
        org.springframework.util.ReflectionUtils.makeAccessible((Field)field);
        return (T)org.springframework.util.ReflectionUtils.getField((Field)field, (Object)targetObject);
    }

    public static <T> T invokeMethod(Object targetObject, String name, Object ... args) {
        Assert.notNull((Object)targetObject, (String)"Target object must not be null");
        Assert.hasText((String)name, (String)"Method name must not be empty");
        try {
            MethodInvoker methodInvoker = new MethodInvoker();
            methodInvoker.setTargetObject(targetObject);
            methodInvoker.setTargetMethod(name);
            methodInvoker.setArguments(args);
            methodInvoker.prepare();
            return (T)methodInvoker.invoke();
        }
        catch (Exception ex) {
            org.springframework.util.ReflectionUtils.handleReflectionException((Exception)ex);
            throw new IllegalStateException("Should never get here");
        }
    }

    public static <T> T invokeStaticMethod(Class<?> targetClass, String name, Object ... args) {
        Assert.notNull(targetClass, (String)"Target class must not be null");
        Assert.hasText((String)name, (String)"Method name must not be empty");
        try {
            MethodInvoker methodInvoker = new MethodInvoker();
            methodInvoker.setTargetClass(targetClass);
            methodInvoker.setTargetMethod(name);
            methodInvoker.setArguments(args);
            methodInvoker.prepare();
            return (T)methodInvoker.invoke();
        }
        catch (Exception ex) {
            org.springframework.util.ReflectionUtils.handleReflectionException((Exception)ex);
            throw new IllegalStateException("Should never get here");
        }
    }

    public static <T> T invokeConstructor(String className, Object ... args) throws ClassNotFoundException {
        Assert.notNull((Object)className, (String)"Target class must not be null");
        Class targetClass = ClassUtils.forName((String)className, null);
        return ReflectionUtils.invokeConstructor(targetClass, args);
    }

    public static <T> T invokeConstructor(Class<?> targetClass, Object ... args) {
        Assert.notNull(targetClass, (String)"Target class must not be null");
        try {
            for (Constructor<?> constructor : targetClass.getDeclaredConstructors()) {
                if (constructor.getParameterCount() != args.length) continue;
                Class[] parameterTypes = constructor.getParameterTypes();
                boolean parametersMatches = IntStream.range(0, args.length).allMatch(i -> ClassUtils.isAssignableValue((Class)parameterTypes[i], (Object)args[i]));
                if (!parametersMatches) continue;
                org.springframework.util.ReflectionUtils.makeAccessible(constructor);
                return (T)constructor.newInstance(args);
            }
            throw new IllegalArgumentException(String.format("Could not find constructor on %s", targetClass));
        }
        catch (Exception ex) {
            org.springframework.util.ReflectionUtils.handleReflectionException((Exception)ex);
            throw new IllegalStateException("Should never get here");
        }
    }

    private static String safeToString(Object target) {
        try {
            return String.format("target object [%s]", target);
        }
        catch (Exception ex) {
            return String.format("target of type [%s] whose toString() method threw [%s]", target != null ? target.getClass().getName() : "unknown", ex);
        }
    }
}

